/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.RestoreStatus;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RestoreStatusStaxUnmarshaller
implements Unmarshaller<RestoreStatus, StaxUnmarshallerContext> {
    private static RestoreStatusStaxUnmarshaller instance;

    @Override
    public RestoreStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        RestoreStatus restoreStatus = new RestoreStatus();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return restoreStatus;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Status", targetDepth)) {
                    restoreStatus.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CurrentRestoreRateInMegaBytesPerSecond", targetDepth)) {
                    restoreStatus.setCurrentRestoreRateInMegaBytesPerSecond(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SnapshotSizeInMegaBytes", targetDepth)) {
                    restoreStatus.setSnapshotSizeInMegaBytes(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProgressInMegaBytes", targetDepth)) {
                    restoreStatus.setProgressInMegaBytes(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ElapsedTimeInSeconds", targetDepth)) {
                    restoreStatus.setElapsedTimeInSeconds(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EstimatedTimeToCompletionInSeconds", targetDepth)) continue;
                restoreStatus.setEstimatedTimeToCompletionInSeconds(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return restoreStatus;
    }

    public static RestoreStatusStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RestoreStatusStaxUnmarshaller();
        }
        return instance;
    }
}

