/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.EndpointDemographic;

@SdkInternalApi
public class EndpointDemographicMarshaller {
    private static final MarshallingInfo<String> APPVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppVersion").build();
    private static final MarshallingInfo<String> LOCALE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Locale").build();
    private static final MarshallingInfo<String> MAKE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Make").build();
    private static final MarshallingInfo<String> MODEL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Model").build();
    private static final MarshallingInfo<String> MODELVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelVersion").build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").build();
    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformVersion").build();
    private static final MarshallingInfo<String> TIMEZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timezone").build();
    private static final EndpointDemographicMarshaller instance = new EndpointDemographicMarshaller();

    public static EndpointDemographicMarshaller getInstance() {
        return instance;
    }

    public void marshall(EndpointDemographic endpointDemographic, ProtocolMarshaller protocolMarshaller) {
        if (endpointDemographic == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(endpointDemographic.getAppVersion(), APPVERSION_BINDING);
            protocolMarshaller.marshall(endpointDemographic.getLocale(), LOCALE_BINDING);
            protocolMarshaller.marshall(endpointDemographic.getMake(), MAKE_BINDING);
            protocolMarshaller.marshall(endpointDemographic.getModel(), MODEL_BINDING);
            protocolMarshaller.marshall(endpointDemographic.getModelVersion(), MODELVERSION_BINDING);
            protocolMarshaller.marshall(endpointDemographic.getPlatform(), PLATFORM_BINDING);
            protocolMarshaller.marshall(endpointDemographic.getPlatformVersion(), PLATFORMVERSION_BINDING);
            protocolMarshaller.marshall(endpointDemographic.getTimezone(), TIMEZONE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

