/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mturk;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mturk.AmazonMTurkAsync;
import com.amazonaws.services.mturk.AmazonMTurkAsyncClientBuilder;
import com.amazonaws.services.mturk.AmazonMTurkClient;
import com.amazonaws.services.mturk.model.AcceptQualificationRequestRequest;
import com.amazonaws.services.mturk.model.AcceptQualificationRequestResult;
import com.amazonaws.services.mturk.model.ApproveAssignmentRequest;
import com.amazonaws.services.mturk.model.ApproveAssignmentResult;
import com.amazonaws.services.mturk.model.AssociateQualificationWithWorkerRequest;
import com.amazonaws.services.mturk.model.AssociateQualificationWithWorkerResult;
import com.amazonaws.services.mturk.model.CreateAdditionalAssignmentsForHITRequest;
import com.amazonaws.services.mturk.model.CreateAdditionalAssignmentsForHITResult;
import com.amazonaws.services.mturk.model.CreateHITRequest;
import com.amazonaws.services.mturk.model.CreateHITResult;
import com.amazonaws.services.mturk.model.CreateHITTypeRequest;
import com.amazonaws.services.mturk.model.CreateHITTypeResult;
import com.amazonaws.services.mturk.model.CreateHITWithHITTypeRequest;
import com.amazonaws.services.mturk.model.CreateHITWithHITTypeResult;
import com.amazonaws.services.mturk.model.CreateQualificationTypeRequest;
import com.amazonaws.services.mturk.model.CreateQualificationTypeResult;
import com.amazonaws.services.mturk.model.CreateWorkerBlockRequest;
import com.amazonaws.services.mturk.model.CreateWorkerBlockResult;
import com.amazonaws.services.mturk.model.DeleteHITRequest;
import com.amazonaws.services.mturk.model.DeleteHITResult;
import com.amazonaws.services.mturk.model.DeleteQualificationTypeRequest;
import com.amazonaws.services.mturk.model.DeleteQualificationTypeResult;
import com.amazonaws.services.mturk.model.DeleteWorkerBlockRequest;
import com.amazonaws.services.mturk.model.DeleteWorkerBlockResult;
import com.amazonaws.services.mturk.model.DisassociateQualificationFromWorkerRequest;
import com.amazonaws.services.mturk.model.DisassociateQualificationFromWorkerResult;
import com.amazonaws.services.mturk.model.GetAccountBalanceRequest;
import com.amazonaws.services.mturk.model.GetAccountBalanceResult;
import com.amazonaws.services.mturk.model.GetAssignmentRequest;
import com.amazonaws.services.mturk.model.GetAssignmentResult;
import com.amazonaws.services.mturk.model.GetFileUploadURLRequest;
import com.amazonaws.services.mturk.model.GetFileUploadURLResult;
import com.amazonaws.services.mturk.model.GetHITRequest;
import com.amazonaws.services.mturk.model.GetHITResult;
import com.amazonaws.services.mturk.model.GetQualificationScoreRequest;
import com.amazonaws.services.mturk.model.GetQualificationScoreResult;
import com.amazonaws.services.mturk.model.GetQualificationTypeRequest;
import com.amazonaws.services.mturk.model.GetQualificationTypeResult;
import com.amazonaws.services.mturk.model.ListAssignmentsForHITRequest;
import com.amazonaws.services.mturk.model.ListAssignmentsForHITResult;
import com.amazonaws.services.mturk.model.ListBonusPaymentsRequest;
import com.amazonaws.services.mturk.model.ListBonusPaymentsResult;
import com.amazonaws.services.mturk.model.ListHITsForQualificationTypeRequest;
import com.amazonaws.services.mturk.model.ListHITsForQualificationTypeResult;
import com.amazonaws.services.mturk.model.ListHITsRequest;
import com.amazonaws.services.mturk.model.ListHITsResult;
import com.amazonaws.services.mturk.model.ListQualificationRequestsRequest;
import com.amazonaws.services.mturk.model.ListQualificationRequestsResult;
import com.amazonaws.services.mturk.model.ListQualificationTypesRequest;
import com.amazonaws.services.mturk.model.ListQualificationTypesResult;
import com.amazonaws.services.mturk.model.ListReviewPolicyResultsForHITRequest;
import com.amazonaws.services.mturk.model.ListReviewPolicyResultsForHITResult;
import com.amazonaws.services.mturk.model.ListReviewableHITsRequest;
import com.amazonaws.services.mturk.model.ListReviewableHITsResult;
import com.amazonaws.services.mturk.model.ListWorkerBlocksRequest;
import com.amazonaws.services.mturk.model.ListWorkerBlocksResult;
import com.amazonaws.services.mturk.model.ListWorkersWithQualificationTypeRequest;
import com.amazonaws.services.mturk.model.ListWorkersWithQualificationTypeResult;
import com.amazonaws.services.mturk.model.NotifyWorkersRequest;
import com.amazonaws.services.mturk.model.NotifyWorkersResult;
import com.amazonaws.services.mturk.model.RejectAssignmentRequest;
import com.amazonaws.services.mturk.model.RejectAssignmentResult;
import com.amazonaws.services.mturk.model.RejectQualificationRequestRequest;
import com.amazonaws.services.mturk.model.RejectQualificationRequestResult;
import com.amazonaws.services.mturk.model.SendBonusRequest;
import com.amazonaws.services.mturk.model.SendBonusResult;
import com.amazonaws.services.mturk.model.SendTestEventNotificationRequest;
import com.amazonaws.services.mturk.model.SendTestEventNotificationResult;
import com.amazonaws.services.mturk.model.UpdateExpirationForHITRequest;
import com.amazonaws.services.mturk.model.UpdateExpirationForHITResult;
import com.amazonaws.services.mturk.model.UpdateHITReviewStatusRequest;
import com.amazonaws.services.mturk.model.UpdateHITReviewStatusResult;
import com.amazonaws.services.mturk.model.UpdateHITTypeOfHITRequest;
import com.amazonaws.services.mturk.model.UpdateHITTypeOfHITResult;
import com.amazonaws.services.mturk.model.UpdateNotificationSettingsRequest;
import com.amazonaws.services.mturk.model.UpdateNotificationSettingsResult;
import com.amazonaws.services.mturk.model.UpdateQualificationTypeRequest;
import com.amazonaws.services.mturk.model.UpdateQualificationTypeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonMTurkAsyncClient
extends AmazonMTurkClient
implements AmazonMTurkAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonMTurkAsyncClientBuilder asyncBuilder() {
        return AmazonMTurkAsyncClientBuilder.standard();
    }

    AmazonMTurkAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptQualificationRequestResult> acceptQualificationRequestAsync(AcceptQualificationRequestRequest request) {
        return this.acceptQualificationRequestAsync(request, null);
    }

    @Override
    public Future<AcceptQualificationRequestResult> acceptQualificationRequestAsync(AcceptQualificationRequestRequest request, final AsyncHandler<AcceptQualificationRequestRequest, AcceptQualificationRequestResult> asyncHandler) {
        final AcceptQualificationRequestRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptQualificationRequestResult>(){

            @Override
            public AcceptQualificationRequestResult call() throws Exception {
                AcceptQualificationRequestResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeAcceptQualificationRequest(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ApproveAssignmentResult> approveAssignmentAsync(ApproveAssignmentRequest request) {
        return this.approveAssignmentAsync(request, null);
    }

    @Override
    public Future<ApproveAssignmentResult> approveAssignmentAsync(ApproveAssignmentRequest request, final AsyncHandler<ApproveAssignmentRequest, ApproveAssignmentResult> asyncHandler) {
        final ApproveAssignmentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ApproveAssignmentResult>(){

            @Override
            public ApproveAssignmentResult call() throws Exception {
                ApproveAssignmentResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeApproveAssignment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateQualificationWithWorkerResult> associateQualificationWithWorkerAsync(AssociateQualificationWithWorkerRequest request) {
        return this.associateQualificationWithWorkerAsync(request, null);
    }

    @Override
    public Future<AssociateQualificationWithWorkerResult> associateQualificationWithWorkerAsync(AssociateQualificationWithWorkerRequest request, final AsyncHandler<AssociateQualificationWithWorkerRequest, AssociateQualificationWithWorkerResult> asyncHandler) {
        final AssociateQualificationWithWorkerRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateQualificationWithWorkerResult>(){

            @Override
            public AssociateQualificationWithWorkerResult call() throws Exception {
                AssociateQualificationWithWorkerResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeAssociateQualificationWithWorker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAdditionalAssignmentsForHITResult> createAdditionalAssignmentsForHITAsync(CreateAdditionalAssignmentsForHITRequest request) {
        return this.createAdditionalAssignmentsForHITAsync(request, null);
    }

    @Override
    public Future<CreateAdditionalAssignmentsForHITResult> createAdditionalAssignmentsForHITAsync(CreateAdditionalAssignmentsForHITRequest request, final AsyncHandler<CreateAdditionalAssignmentsForHITRequest, CreateAdditionalAssignmentsForHITResult> asyncHandler) {
        final CreateAdditionalAssignmentsForHITRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAdditionalAssignmentsForHITResult>(){

            @Override
            public CreateAdditionalAssignmentsForHITResult call() throws Exception {
                CreateAdditionalAssignmentsForHITResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeCreateAdditionalAssignmentsForHIT(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHITResult> createHITAsync(CreateHITRequest request) {
        return this.createHITAsync(request, null);
    }

    @Override
    public Future<CreateHITResult> createHITAsync(CreateHITRequest request, final AsyncHandler<CreateHITRequest, CreateHITResult> asyncHandler) {
        final CreateHITRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateHITResult>(){

            @Override
            public CreateHITResult call() throws Exception {
                CreateHITResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeCreateHIT(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHITTypeResult> createHITTypeAsync(CreateHITTypeRequest request) {
        return this.createHITTypeAsync(request, null);
    }

    @Override
    public Future<CreateHITTypeResult> createHITTypeAsync(CreateHITTypeRequest request, final AsyncHandler<CreateHITTypeRequest, CreateHITTypeResult> asyncHandler) {
        final CreateHITTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateHITTypeResult>(){

            @Override
            public CreateHITTypeResult call() throws Exception {
                CreateHITTypeResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeCreateHITType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateHITWithHITTypeResult> createHITWithHITTypeAsync(CreateHITWithHITTypeRequest request) {
        return this.createHITWithHITTypeAsync(request, null);
    }

    @Override
    public Future<CreateHITWithHITTypeResult> createHITWithHITTypeAsync(CreateHITWithHITTypeRequest request, final AsyncHandler<CreateHITWithHITTypeRequest, CreateHITWithHITTypeResult> asyncHandler) {
        final CreateHITWithHITTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateHITWithHITTypeResult>(){

            @Override
            public CreateHITWithHITTypeResult call() throws Exception {
                CreateHITWithHITTypeResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeCreateHITWithHITType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateQualificationTypeResult> createQualificationTypeAsync(CreateQualificationTypeRequest request) {
        return this.createQualificationTypeAsync(request, null);
    }

    @Override
    public Future<CreateQualificationTypeResult> createQualificationTypeAsync(CreateQualificationTypeRequest request, final AsyncHandler<CreateQualificationTypeRequest, CreateQualificationTypeResult> asyncHandler) {
        final CreateQualificationTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateQualificationTypeResult>(){

            @Override
            public CreateQualificationTypeResult call() throws Exception {
                CreateQualificationTypeResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeCreateQualificationType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWorkerBlockResult> createWorkerBlockAsync(CreateWorkerBlockRequest request) {
        return this.createWorkerBlockAsync(request, null);
    }

    @Override
    public Future<CreateWorkerBlockResult> createWorkerBlockAsync(CreateWorkerBlockRequest request, final AsyncHandler<CreateWorkerBlockRequest, CreateWorkerBlockResult> asyncHandler) {
        final CreateWorkerBlockRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWorkerBlockResult>(){

            @Override
            public CreateWorkerBlockResult call() throws Exception {
                CreateWorkerBlockResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeCreateWorkerBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteHITResult> deleteHITAsync(DeleteHITRequest request) {
        return this.deleteHITAsync(request, null);
    }

    @Override
    public Future<DeleteHITResult> deleteHITAsync(DeleteHITRequest request, final AsyncHandler<DeleteHITRequest, DeleteHITResult> asyncHandler) {
        final DeleteHITRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteHITResult>(){

            @Override
            public DeleteHITResult call() throws Exception {
                DeleteHITResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeDeleteHIT(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteQualificationTypeResult> deleteQualificationTypeAsync(DeleteQualificationTypeRequest request) {
        return this.deleteQualificationTypeAsync(request, null);
    }

    @Override
    public Future<DeleteQualificationTypeResult> deleteQualificationTypeAsync(DeleteQualificationTypeRequest request, final AsyncHandler<DeleteQualificationTypeRequest, DeleteQualificationTypeResult> asyncHandler) {
        final DeleteQualificationTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteQualificationTypeResult>(){

            @Override
            public DeleteQualificationTypeResult call() throws Exception {
                DeleteQualificationTypeResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeDeleteQualificationType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWorkerBlockResult> deleteWorkerBlockAsync(DeleteWorkerBlockRequest request) {
        return this.deleteWorkerBlockAsync(request, null);
    }

    @Override
    public Future<DeleteWorkerBlockResult> deleteWorkerBlockAsync(DeleteWorkerBlockRequest request, final AsyncHandler<DeleteWorkerBlockRequest, DeleteWorkerBlockResult> asyncHandler) {
        final DeleteWorkerBlockRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteWorkerBlockResult>(){

            @Override
            public DeleteWorkerBlockResult call() throws Exception {
                DeleteWorkerBlockResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeDeleteWorkerBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateQualificationFromWorkerResult> disassociateQualificationFromWorkerAsync(DisassociateQualificationFromWorkerRequest request) {
        return this.disassociateQualificationFromWorkerAsync(request, null);
    }

    @Override
    public Future<DisassociateQualificationFromWorkerResult> disassociateQualificationFromWorkerAsync(DisassociateQualificationFromWorkerRequest request, final AsyncHandler<DisassociateQualificationFromWorkerRequest, DisassociateQualificationFromWorkerResult> asyncHandler) {
        final DisassociateQualificationFromWorkerRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateQualificationFromWorkerResult>(){

            @Override
            public DisassociateQualificationFromWorkerResult call() throws Exception {
                DisassociateQualificationFromWorkerResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeDisassociateQualificationFromWorker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountBalanceResult> getAccountBalanceAsync(GetAccountBalanceRequest request) {
        return this.getAccountBalanceAsync(request, null);
    }

    @Override
    public Future<GetAccountBalanceResult> getAccountBalanceAsync(GetAccountBalanceRequest request, final AsyncHandler<GetAccountBalanceRequest, GetAccountBalanceResult> asyncHandler) {
        final GetAccountBalanceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccountBalanceResult>(){

            @Override
            public GetAccountBalanceResult call() throws Exception {
                GetAccountBalanceResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeGetAccountBalance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAssignmentResult> getAssignmentAsync(GetAssignmentRequest request) {
        return this.getAssignmentAsync(request, null);
    }

    @Override
    public Future<GetAssignmentResult> getAssignmentAsync(GetAssignmentRequest request, final AsyncHandler<GetAssignmentRequest, GetAssignmentResult> asyncHandler) {
        final GetAssignmentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAssignmentResult>(){

            @Override
            public GetAssignmentResult call() throws Exception {
                GetAssignmentResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeGetAssignment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFileUploadURLResult> getFileUploadURLAsync(GetFileUploadURLRequest request) {
        return this.getFileUploadURLAsync(request, null);
    }

    @Override
    public Future<GetFileUploadURLResult> getFileUploadURLAsync(GetFileUploadURLRequest request, final AsyncHandler<GetFileUploadURLRequest, GetFileUploadURLResult> asyncHandler) {
        final GetFileUploadURLRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFileUploadURLResult>(){

            @Override
            public GetFileUploadURLResult call() throws Exception {
                GetFileUploadURLResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeGetFileUploadURL(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetHITResult> getHITAsync(GetHITRequest request) {
        return this.getHITAsync(request, null);
    }

    @Override
    public Future<GetHITResult> getHITAsync(GetHITRequest request, final AsyncHandler<GetHITRequest, GetHITResult> asyncHandler) {
        final GetHITRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetHITResult>(){

            @Override
            public GetHITResult call() throws Exception {
                GetHITResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeGetHIT(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQualificationScoreResult> getQualificationScoreAsync(GetQualificationScoreRequest request) {
        return this.getQualificationScoreAsync(request, null);
    }

    @Override
    public Future<GetQualificationScoreResult> getQualificationScoreAsync(GetQualificationScoreRequest request, final AsyncHandler<GetQualificationScoreRequest, GetQualificationScoreResult> asyncHandler) {
        final GetQualificationScoreRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQualificationScoreResult>(){

            @Override
            public GetQualificationScoreResult call() throws Exception {
                GetQualificationScoreResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeGetQualificationScore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQualificationTypeResult> getQualificationTypeAsync(GetQualificationTypeRequest request) {
        return this.getQualificationTypeAsync(request, null);
    }

    @Override
    public Future<GetQualificationTypeResult> getQualificationTypeAsync(GetQualificationTypeRequest request, final AsyncHandler<GetQualificationTypeRequest, GetQualificationTypeResult> asyncHandler) {
        final GetQualificationTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQualificationTypeResult>(){

            @Override
            public GetQualificationTypeResult call() throws Exception {
                GetQualificationTypeResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeGetQualificationType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssignmentsForHITResult> listAssignmentsForHITAsync(ListAssignmentsForHITRequest request) {
        return this.listAssignmentsForHITAsync(request, null);
    }

    @Override
    public Future<ListAssignmentsForHITResult> listAssignmentsForHITAsync(ListAssignmentsForHITRequest request, final AsyncHandler<ListAssignmentsForHITRequest, ListAssignmentsForHITResult> asyncHandler) {
        final ListAssignmentsForHITRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssignmentsForHITResult>(){

            @Override
            public ListAssignmentsForHITResult call() throws Exception {
                ListAssignmentsForHITResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListAssignmentsForHIT(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBonusPaymentsResult> listBonusPaymentsAsync(ListBonusPaymentsRequest request) {
        return this.listBonusPaymentsAsync(request, null);
    }

    @Override
    public Future<ListBonusPaymentsResult> listBonusPaymentsAsync(ListBonusPaymentsRequest request, final AsyncHandler<ListBonusPaymentsRequest, ListBonusPaymentsResult> asyncHandler) {
        final ListBonusPaymentsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBonusPaymentsResult>(){

            @Override
            public ListBonusPaymentsResult call() throws Exception {
                ListBonusPaymentsResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListBonusPayments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHITsResult> listHITsAsync(ListHITsRequest request) {
        return this.listHITsAsync(request, null);
    }

    @Override
    public Future<ListHITsResult> listHITsAsync(ListHITsRequest request, final AsyncHandler<ListHITsRequest, ListHITsResult> asyncHandler) {
        final ListHITsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListHITsResult>(){

            @Override
            public ListHITsResult call() throws Exception {
                ListHITsResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListHITs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHITsForQualificationTypeResult> listHITsForQualificationTypeAsync(ListHITsForQualificationTypeRequest request) {
        return this.listHITsForQualificationTypeAsync(request, null);
    }

    @Override
    public Future<ListHITsForQualificationTypeResult> listHITsForQualificationTypeAsync(ListHITsForQualificationTypeRequest request, final AsyncHandler<ListHITsForQualificationTypeRequest, ListHITsForQualificationTypeResult> asyncHandler) {
        final ListHITsForQualificationTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListHITsForQualificationTypeResult>(){

            @Override
            public ListHITsForQualificationTypeResult call() throws Exception {
                ListHITsForQualificationTypeResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListHITsForQualificationType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQualificationRequestsResult> listQualificationRequestsAsync(ListQualificationRequestsRequest request) {
        return this.listQualificationRequestsAsync(request, null);
    }

    @Override
    public Future<ListQualificationRequestsResult> listQualificationRequestsAsync(ListQualificationRequestsRequest request, final AsyncHandler<ListQualificationRequestsRequest, ListQualificationRequestsResult> asyncHandler) {
        final ListQualificationRequestsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListQualificationRequestsResult>(){

            @Override
            public ListQualificationRequestsResult call() throws Exception {
                ListQualificationRequestsResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListQualificationRequests(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListQualificationTypesResult> listQualificationTypesAsync(ListQualificationTypesRequest request) {
        return this.listQualificationTypesAsync(request, null);
    }

    @Override
    public Future<ListQualificationTypesResult> listQualificationTypesAsync(ListQualificationTypesRequest request, final AsyncHandler<ListQualificationTypesRequest, ListQualificationTypesResult> asyncHandler) {
        final ListQualificationTypesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListQualificationTypesResult>(){

            @Override
            public ListQualificationTypesResult call() throws Exception {
                ListQualificationTypesResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListQualificationTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReviewPolicyResultsForHITResult> listReviewPolicyResultsForHITAsync(ListReviewPolicyResultsForHITRequest request) {
        return this.listReviewPolicyResultsForHITAsync(request, null);
    }

    @Override
    public Future<ListReviewPolicyResultsForHITResult> listReviewPolicyResultsForHITAsync(ListReviewPolicyResultsForHITRequest request, final AsyncHandler<ListReviewPolicyResultsForHITRequest, ListReviewPolicyResultsForHITResult> asyncHandler) {
        final ListReviewPolicyResultsForHITRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReviewPolicyResultsForHITResult>(){

            @Override
            public ListReviewPolicyResultsForHITResult call() throws Exception {
                ListReviewPolicyResultsForHITResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListReviewPolicyResultsForHIT(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReviewableHITsResult> listReviewableHITsAsync(ListReviewableHITsRequest request) {
        return this.listReviewableHITsAsync(request, null);
    }

    @Override
    public Future<ListReviewableHITsResult> listReviewableHITsAsync(ListReviewableHITsRequest request, final AsyncHandler<ListReviewableHITsRequest, ListReviewableHITsResult> asyncHandler) {
        final ListReviewableHITsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReviewableHITsResult>(){

            @Override
            public ListReviewableHITsResult call() throws Exception {
                ListReviewableHITsResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListReviewableHITs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkerBlocksResult> listWorkerBlocksAsync(ListWorkerBlocksRequest request) {
        return this.listWorkerBlocksAsync(request, null);
    }

    @Override
    public Future<ListWorkerBlocksResult> listWorkerBlocksAsync(ListWorkerBlocksRequest request, final AsyncHandler<ListWorkerBlocksRequest, ListWorkerBlocksResult> asyncHandler) {
        final ListWorkerBlocksRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkerBlocksResult>(){

            @Override
            public ListWorkerBlocksResult call() throws Exception {
                ListWorkerBlocksResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListWorkerBlocks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWorkersWithQualificationTypeResult> listWorkersWithQualificationTypeAsync(ListWorkersWithQualificationTypeRequest request) {
        return this.listWorkersWithQualificationTypeAsync(request, null);
    }

    @Override
    public Future<ListWorkersWithQualificationTypeResult> listWorkersWithQualificationTypeAsync(ListWorkersWithQualificationTypeRequest request, final AsyncHandler<ListWorkersWithQualificationTypeRequest, ListWorkersWithQualificationTypeResult> asyncHandler) {
        final ListWorkersWithQualificationTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListWorkersWithQualificationTypeResult>(){

            @Override
            public ListWorkersWithQualificationTypeResult call() throws Exception {
                ListWorkersWithQualificationTypeResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeListWorkersWithQualificationType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<NotifyWorkersResult> notifyWorkersAsync(NotifyWorkersRequest request) {
        return this.notifyWorkersAsync(request, null);
    }

    @Override
    public Future<NotifyWorkersResult> notifyWorkersAsync(NotifyWorkersRequest request, final AsyncHandler<NotifyWorkersRequest, NotifyWorkersResult> asyncHandler) {
        final NotifyWorkersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<NotifyWorkersResult>(){

            @Override
            public NotifyWorkersResult call() throws Exception {
                NotifyWorkersResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeNotifyWorkers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectAssignmentResult> rejectAssignmentAsync(RejectAssignmentRequest request) {
        return this.rejectAssignmentAsync(request, null);
    }

    @Override
    public Future<RejectAssignmentResult> rejectAssignmentAsync(RejectAssignmentRequest request, final AsyncHandler<RejectAssignmentRequest, RejectAssignmentResult> asyncHandler) {
        final RejectAssignmentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RejectAssignmentResult>(){

            @Override
            public RejectAssignmentResult call() throws Exception {
                RejectAssignmentResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeRejectAssignment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectQualificationRequestResult> rejectQualificationRequestAsync(RejectQualificationRequestRequest request) {
        return this.rejectQualificationRequestAsync(request, null);
    }

    @Override
    public Future<RejectQualificationRequestResult> rejectQualificationRequestAsync(RejectQualificationRequestRequest request, final AsyncHandler<RejectQualificationRequestRequest, RejectQualificationRequestResult> asyncHandler) {
        final RejectQualificationRequestRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RejectQualificationRequestResult>(){

            @Override
            public RejectQualificationRequestResult call() throws Exception {
                RejectQualificationRequestResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeRejectQualificationRequest(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendBonusResult> sendBonusAsync(SendBonusRequest request) {
        return this.sendBonusAsync(request, null);
    }

    @Override
    public Future<SendBonusResult> sendBonusAsync(SendBonusRequest request, final AsyncHandler<SendBonusRequest, SendBonusResult> asyncHandler) {
        final SendBonusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendBonusResult>(){

            @Override
            public SendBonusResult call() throws Exception {
                SendBonusResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeSendBonus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendTestEventNotificationResult> sendTestEventNotificationAsync(SendTestEventNotificationRequest request) {
        return this.sendTestEventNotificationAsync(request, null);
    }

    @Override
    public Future<SendTestEventNotificationResult> sendTestEventNotificationAsync(SendTestEventNotificationRequest request, final AsyncHandler<SendTestEventNotificationRequest, SendTestEventNotificationResult> asyncHandler) {
        final SendTestEventNotificationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendTestEventNotificationResult>(){

            @Override
            public SendTestEventNotificationResult call() throws Exception {
                SendTestEventNotificationResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeSendTestEventNotification(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateExpirationForHITResult> updateExpirationForHITAsync(UpdateExpirationForHITRequest request) {
        return this.updateExpirationForHITAsync(request, null);
    }

    @Override
    public Future<UpdateExpirationForHITResult> updateExpirationForHITAsync(UpdateExpirationForHITRequest request, final AsyncHandler<UpdateExpirationForHITRequest, UpdateExpirationForHITResult> asyncHandler) {
        final UpdateExpirationForHITRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateExpirationForHITResult>(){

            @Override
            public UpdateExpirationForHITResult call() throws Exception {
                UpdateExpirationForHITResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeUpdateExpirationForHIT(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHITReviewStatusResult> updateHITReviewStatusAsync(UpdateHITReviewStatusRequest request) {
        return this.updateHITReviewStatusAsync(request, null);
    }

    @Override
    public Future<UpdateHITReviewStatusResult> updateHITReviewStatusAsync(UpdateHITReviewStatusRequest request, final AsyncHandler<UpdateHITReviewStatusRequest, UpdateHITReviewStatusResult> asyncHandler) {
        final UpdateHITReviewStatusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateHITReviewStatusResult>(){

            @Override
            public UpdateHITReviewStatusResult call() throws Exception {
                UpdateHITReviewStatusResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeUpdateHITReviewStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateHITTypeOfHITResult> updateHITTypeOfHITAsync(UpdateHITTypeOfHITRequest request) {
        return this.updateHITTypeOfHITAsync(request, null);
    }

    @Override
    public Future<UpdateHITTypeOfHITResult> updateHITTypeOfHITAsync(UpdateHITTypeOfHITRequest request, final AsyncHandler<UpdateHITTypeOfHITRequest, UpdateHITTypeOfHITResult> asyncHandler) {
        final UpdateHITTypeOfHITRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateHITTypeOfHITResult>(){

            @Override
            public UpdateHITTypeOfHITResult call() throws Exception {
                UpdateHITTypeOfHITResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeUpdateHITTypeOfHIT(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNotificationSettingsResult> updateNotificationSettingsAsync(UpdateNotificationSettingsRequest request) {
        return this.updateNotificationSettingsAsync(request, null);
    }

    @Override
    public Future<UpdateNotificationSettingsResult> updateNotificationSettingsAsync(UpdateNotificationSettingsRequest request, final AsyncHandler<UpdateNotificationSettingsRequest, UpdateNotificationSettingsResult> asyncHandler) {
        final UpdateNotificationSettingsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNotificationSettingsResult>(){

            @Override
            public UpdateNotificationSettingsResult call() throws Exception {
                UpdateNotificationSettingsResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeUpdateNotificationSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateQualificationTypeResult> updateQualificationTypeAsync(UpdateQualificationTypeRequest request) {
        return this.updateQualificationTypeAsync(request, null);
    }

    @Override
    public Future<UpdateQualificationTypeResult> updateQualificationTypeAsync(UpdateQualificationTypeRequest request, final AsyncHandler<UpdateQualificationTypeRequest, UpdateQualificationTypeResult> asyncHandler) {
        final UpdateQualificationTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateQualificationTypeResult>(){

            @Override
            public UpdateQualificationTypeResult call() throws Exception {
                UpdateQualificationTypeResult result = null;
                try {
                    result = AmazonMTurkAsyncClient.this.executeUpdateQualificationType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

