/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.machinelearning.AmazonMachineLearning;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsRequest;
import com.amazonaws.services.machinelearning.model.DescribeBatchPredictionsResult;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesRequest;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesResult;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsRequest;
import com.amazonaws.services.machinelearning.model.DescribeEvaluationsResult;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsRequest;
import com.amazonaws.services.machinelearning.model.DescribeMLModelsResult;
import com.amazonaws.services.machinelearning.waiters.BatchPredictionAvailable;
import com.amazonaws.services.machinelearning.waiters.DataSourceAvailable;
import com.amazonaws.services.machinelearning.waiters.DescribeBatchPredictionsFunction;
import com.amazonaws.services.machinelearning.waiters.DescribeDataSourcesFunction;
import com.amazonaws.services.machinelearning.waiters.DescribeEvaluationsFunction;
import com.amazonaws.services.machinelearning.waiters.DescribeMLModelsFunction;
import com.amazonaws.services.machinelearning.waiters.EvaluationAvailable;
import com.amazonaws.services.machinelearning.waiters.MLModelAvailable;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonMachineLearningWaiters {
    private final AmazonMachineLearning client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonMachineLearningWaiters(AmazonMachineLearning client) {
        this.client = client;
    }

    public Waiter<DescribeBatchPredictionsRequest> batchPredictionAvailable() {
        return new WaiterBuilder<DescribeBatchPredictionsRequest, DescribeBatchPredictionsResult>().withSdkFunction(new DescribeBatchPredictionsFunction(this.client)).withAcceptors(new BatchPredictionAvailable.IsCOMPLETEDMatcher(), new BatchPredictionAvailable.IsFAILEDMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeMLModelsRequest> mLModelAvailable() {
        return new WaiterBuilder<DescribeMLModelsRequest, DescribeMLModelsResult>().withSdkFunction(new DescribeMLModelsFunction(this.client)).withAcceptors(new MLModelAvailable.IsCOMPLETEDMatcher(), new MLModelAvailable.IsFAILEDMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDataSourcesRequest> dataSourceAvailable() {
        return new WaiterBuilder<DescribeDataSourcesRequest, DescribeDataSourcesResult>().withSdkFunction(new DescribeDataSourcesFunction(this.client)).withAcceptors(new DataSourceAvailable.IsCOMPLETEDMatcher(), new DataSourceAvailable.IsFAILEDMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEvaluationsRequest> evaluationAvailable() {
        return new WaiterBuilder<DescribeEvaluationsRequest, DescribeEvaluationsResult>().withSdkFunction(new DescribeEvaluationsFunction(this.client)).withAcceptors(new EvaluationAvailable.IsCOMPLETEDMatcher(), new EvaluationAvailable.IsFAILEDMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

