/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.ResourceLocation;

@SdkInternalApi
public class ResourceLocationMarshaller {
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").build();
    private static final MarshallingInfo<String> REGIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionName").build();
    private static final ResourceLocationMarshaller instance = new ResourceLocationMarshaller();

    public static ResourceLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceLocation resourceLocation, ProtocolMarshaller protocolMarshaller) {
        if (resourceLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourceLocation.getAvailabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(resourceLocation.getRegionName(), REGIONNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

