/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesis.model.EncryptionType;
import com.amazonaws.services.kinesis.model.transform.RecordMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;

public class Record
implements Serializable,
Cloneable,
StructuredPojo {
    private String sequenceNumber;
    private Date approximateArrivalTimestamp;
    private ByteBuffer data;
    private String partitionKey;
    private String encryptionType;

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Record withSequenceNumber(String sequenceNumber) {
        this.setSequenceNumber(sequenceNumber);
        return this;
    }

    public void setApproximateArrivalTimestamp(Date approximateArrivalTimestamp) {
        this.approximateArrivalTimestamp = approximateArrivalTimestamp;
    }

    public Date getApproximateArrivalTimestamp() {
        return this.approximateArrivalTimestamp;
    }

    public Record withApproximateArrivalTimestamp(Date approximateArrivalTimestamp) {
        this.setApproximateArrivalTimestamp(approximateArrivalTimestamp);
        return this;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public Record withData(ByteBuffer data) {
        this.setData(data);
        return this;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public Record withPartitionKey(String partitionKey) {
        this.setPartitionKey(partitionKey);
        return this;
    }

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public Record withEncryptionType(String encryptionType) {
        this.setEncryptionType(encryptionType);
        return this;
    }

    public void setEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType.toString();
    }

    public Record withEncryptionType(EncryptionType encryptionType) {
        this.setEncryptionType(encryptionType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(this.getSequenceNumber()).append(",");
        }
        if (this.getApproximateArrivalTimestamp() != null) {
            sb.append("ApproximateArrivalTimestamp: ").append(this.getApproximateArrivalTimestamp()).append(",");
        }
        if (this.getData() != null) {
            sb.append("Data: ").append(this.getData()).append(",");
        }
        if (this.getPartitionKey() != null) {
            sb.append("PartitionKey: ").append(this.getPartitionKey()).append(",");
        }
        if (this.getEncryptionType() != null) {
            sb.append("EncryptionType: ").append(this.getEncryptionType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        if (other.getSequenceNumber() == null ^ this.getSequenceNumber() == null) {
            return false;
        }
        if (other.getSequenceNumber() != null && !other.getSequenceNumber().equals(this.getSequenceNumber())) {
            return false;
        }
        if (other.getApproximateArrivalTimestamp() == null ^ this.getApproximateArrivalTimestamp() == null) {
            return false;
        }
        if (other.getApproximateArrivalTimestamp() != null && !other.getApproximateArrivalTimestamp().equals(this.getApproximateArrivalTimestamp())) {
            return false;
        }
        if (other.getData() == null ^ this.getData() == null) {
            return false;
        }
        if (other.getData() != null && !other.getData().equals(this.getData())) {
            return false;
        }
        if (other.getPartitionKey() == null ^ this.getPartitionKey() == null) {
            return false;
        }
        if (other.getPartitionKey() != null && !other.getPartitionKey().equals(this.getPartitionKey())) {
            return false;
        }
        if (other.getEncryptionType() == null ^ this.getEncryptionType() == null) {
            return false;
        }
        return other.getEncryptionType() == null || other.getEncryptionType().equals(this.getEncryptionType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSequenceNumber() == null ? 0 : this.getSequenceNumber().hashCode());
        hashCode = 31 * hashCode + (this.getApproximateArrivalTimestamp() == null ? 0 : this.getApproximateArrivalTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getData() == null ? 0 : this.getData().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionKey() == null ? 0 : this.getPartitionKey().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionType() == null ? 0 : this.getEncryptionType().hashCode());
        return hashCode;
    }

    public Record clone() {
        try {
            return (Record)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

