/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrass.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrass.model.Function;
import com.amazonaws.services.greengrass.model.transform.FunctionDefinitionVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FunctionDefinitionVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Function> functions;

    public List<Function> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Collection<Function> functions) {
        if (functions == null) {
            this.functions = null;
            return;
        }
        this.functions = new ArrayList<Function>(functions);
    }

    public FunctionDefinitionVersion withFunctions(Function ... functions) {
        if (this.functions == null) {
            this.setFunctions(new ArrayList<Function>(functions.length));
        }
        for (Function ele : functions) {
            this.functions.add(ele);
        }
        return this;
    }

    public FunctionDefinitionVersion withFunctions(Collection<Function> functions) {
        this.setFunctions(functions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctions() != null) {
            sb.append("Functions: ").append(this.getFunctions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionDefinitionVersion)) {
            return false;
        }
        FunctionDefinitionVersion other = (FunctionDefinitionVersion)obj;
        if (other.getFunctions() == null ^ this.getFunctions() == null) {
            return false;
        }
        return other.getFunctions() == null || other.getFunctions().equals(this.getFunctions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctions() == null ? 0 : this.getFunctions().hashCode());
        return hashCode;
    }

    public FunctionDefinitionVersion clone() {
        try {
            return (FunctionDefinitionVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

