/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeSSLPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeSSLPoliciesRequestMarshaller
implements Marshaller<Request<DescribeSSLPoliciesRequest>, DescribeSSLPoliciesRequest> {
    @Override
    public Request<DescribeSSLPoliciesRequest> marshall(DescribeSSLPoliciesRequest describeSSLPoliciesRequest) {
        if (describeSSLPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSSLPoliciesRequest> request = new DefaultRequest<DescribeSSLPoliciesRequest>(describeSSLPoliciesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeSSLPolicies");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> namesList = describeSSLPoliciesRequest.getNames();
        if (namesList != null) {
            if (namesList.isEmpty()) {
                request.addParameter("Names", "");
            } else {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString(namesListValue));
                    }
                    ++namesListIndex;
                }
            }
        }
        if (describeSSLPoliciesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeSSLPoliciesRequest.getMarker()));
        }
        if (describeSSLPoliciesRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger(describeSSLPoliciesRequest.getPageSize()));
        }
        return request;
    }
}

