/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticloadbalancing.model.AccessLog;
import com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings;
import com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyLoadBalancerAttributesRequestMarshaller
implements Marshaller<Request<ModifyLoadBalancerAttributesRequest>, ModifyLoadBalancerAttributesRequest> {
    @Override
    public Request<ModifyLoadBalancerAttributesRequest> marshall(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        LoadBalancerAttributes loadBalancerAttributes;
        if (modifyLoadBalancerAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyLoadBalancerAttributesRequest> request = new DefaultRequest<ModifyLoadBalancerAttributesRequest>(modifyLoadBalancerAttributesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyLoadBalancerAttributes");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyLoadBalancerAttributesRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString(modifyLoadBalancerAttributesRequest.getLoadBalancerName()));
        }
        if ((loadBalancerAttributes = modifyLoadBalancerAttributesRequest.getLoadBalancerAttributes()) != null) {
            SdkInternalList additionalAttributesList;
            ConnectionSettings connectionSettings;
            ConnectionDraining connectionDraining;
            AccessLog accessLog;
            CrossZoneLoadBalancing crossZoneLoadBalancing = loadBalancerAttributes.getCrossZoneLoadBalancing();
            if (crossZoneLoadBalancing != null && crossZoneLoadBalancing.getEnabled() != null) {
                request.addParameter("LoadBalancerAttributes.CrossZoneLoadBalancing.Enabled", StringUtils.fromBoolean(crossZoneLoadBalancing.getEnabled()));
            }
            if ((accessLog = loadBalancerAttributes.getAccessLog()) != null) {
                if (accessLog.getEnabled() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.Enabled", StringUtils.fromBoolean(accessLog.getEnabled()));
                }
                if (accessLog.getS3BucketName() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketName", StringUtils.fromString(accessLog.getS3BucketName()));
                }
                if (accessLog.getEmitInterval() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.EmitInterval", StringUtils.fromInteger(accessLog.getEmitInterval()));
                }
                if (accessLog.getS3BucketPrefix() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketPrefix", StringUtils.fromString(accessLog.getS3BucketPrefix()));
                }
            }
            if ((connectionDraining = loadBalancerAttributes.getConnectionDraining()) != null) {
                if (connectionDraining.getEnabled() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Enabled", StringUtils.fromBoolean(connectionDraining.getEnabled()));
                }
                if (connectionDraining.getTimeout() != null) {
                    request.addParameter("LoadBalancerAttributes.ConnectionDraining.Timeout", StringUtils.fromInteger(connectionDraining.getTimeout()));
                }
            }
            if ((connectionSettings = loadBalancerAttributes.getConnectionSettings()) != null && connectionSettings.getIdleTimeout() != null) {
                request.addParameter("LoadBalancerAttributes.ConnectionSettings.IdleTimeout", StringUtils.fromInteger(connectionSettings.getIdleTimeout()));
            }
            if (!(additionalAttributesList = (SdkInternalList)loadBalancerAttributes.getAdditionalAttributes()).isEmpty() || !additionalAttributesList.isAutoConstruct()) {
                int additionalAttributesListIndex = 1;
                for (AdditionalAttribute additionalAttributesListValue : additionalAttributesList) {
                    if (additionalAttributesListValue.getKey() != null) {
                        request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Key", StringUtils.fromString(additionalAttributesListValue.getKey()));
                    }
                    if (additionalAttributesListValue.getValue() != null) {
                        request.addParameter("LoadBalancerAttributes.AdditionalAttributes.member." + additionalAttributesListIndex + ".Value", StringUtils.fromString(additionalAttributesListValue.getValue()));
                    }
                    ++additionalAttributesListIndex;
                }
            }
        }
        return request;
    }
}

