/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    @Override
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        SdkInternalList describeSnapshotsRequestSnapshotIdsList;
        SdkInternalList describeSnapshotsRequestRestorableByUserIdsList;
        SdkInternalList describeSnapshotsRequestOwnerIdsList;
        if (describeSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSnapshotsRequest> request = new DefaultRequest<DescribeSnapshotsRequest>(describeSnapshotsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeSnapshotsRequestFiltersList = (SdkInternalList)describeSnapshotsRequest.getFilters();
        if (!describeSnapshotsRequestFiltersList.isEmpty() || !describeSnapshotsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describeSnapshotsRequestFiltersListValue : describeSnapshotsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describeSnapshotsRequestFiltersListValue).getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(((Filter)describeSnapshotsRequestFiltersListValue).getName()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describeSnapshotsRequestFiltersListValue).getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeSnapshotsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeSnapshotsRequest.getMaxResults()));
        }
        if (describeSnapshotsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeSnapshotsRequest.getNextToken()));
        }
        if (!(describeSnapshotsRequestOwnerIdsList = (SdkInternalList)describeSnapshotsRequest.getOwnerIds()).isEmpty() || !describeSnapshotsRequestOwnerIdsList.isAutoConstruct()) {
            int ownerIdsListIndex = 1;
            for (Object describeSnapshotsRequestOwnerIdsListValue : describeSnapshotsRequestOwnerIdsList) {
                if (describeSnapshotsRequestOwnerIdsListValue != null) {
                    request.addParameter("Owner." + ownerIdsListIndex, StringUtils.fromString((String)describeSnapshotsRequestOwnerIdsListValue));
                }
                ++ownerIdsListIndex;
            }
        }
        if (!(describeSnapshotsRequestRestorableByUserIdsList = (SdkInternalList)describeSnapshotsRequest.getRestorableByUserIds()).isEmpty() || !describeSnapshotsRequestRestorableByUserIdsList.isAutoConstruct()) {
            int restorableByUserIdsListIndex = 1;
            for (String describeSnapshotsRequestRestorableByUserIdsListValue : describeSnapshotsRequestRestorableByUserIdsList) {
                if (describeSnapshotsRequestRestorableByUserIdsListValue != null) {
                    request.addParameter("RestorableBy." + restorableByUserIdsListIndex, StringUtils.fromString(describeSnapshotsRequestRestorableByUserIdsListValue));
                }
                ++restorableByUserIdsListIndex;
            }
        }
        if (!(describeSnapshotsRequestSnapshotIdsList = (SdkInternalList)describeSnapshotsRequest.getSnapshotIds()).isEmpty() || !describeSnapshotsRequestSnapshotIdsList.isAutoConstruct()) {
            int snapshotIdsListIndex = 1;
            for (String describeSnapshotsRequestSnapshotIdsListValue : describeSnapshotsRequestSnapshotIdsList) {
                if (describeSnapshotsRequestSnapshotIdsListValue != null) {
                    request.addParameter("SnapshotId." + snapshotIdsListIndex, StringUtils.fromString(describeSnapshotsRequestSnapshotIdsListValue));
                }
                ++snapshotIdsListIndex;
            }
        }
        return request;
    }
}

