/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateRouteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateRouteRequestMarshaller
implements Marshaller<Request<CreateRouteRequest>, CreateRouteRequest> {
    @Override
    public Request<CreateRouteRequest> marshall(CreateRouteRequest createRouteRequest) {
        if (createRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateRouteRequest> request = new DefaultRequest<CreateRouteRequest>(createRouteRequest, "AmazonEC2");
        request.addParameter("Action", "CreateRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRouteRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString(createRouteRequest.getDestinationCidrBlock()));
        }
        if (createRouteRequest.getDestinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringUtils.fromString(createRouteRequest.getDestinationIpv6CidrBlock()));
        }
        if (createRouteRequest.getEgressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringUtils.fromString(createRouteRequest.getEgressOnlyInternetGatewayId()));
        }
        if (createRouteRequest.getGatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString(createRouteRequest.getGatewayId()));
        }
        if (createRouteRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createRouteRequest.getInstanceId()));
        }
        if (createRouteRequest.getNatGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString(createRouteRequest.getNatGatewayId()));
        }
        if (createRouteRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(createRouteRequest.getNetworkInterfaceId()));
        }
        if (createRouteRequest.getRouteTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString(createRouteRequest.getRouteTableId()));
        }
        if (createRouteRequest.getVpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString(createRouteRequest.getVpcPeeringConnectionId()));
        }
        return request;
    }
}

