/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directconnect.model.BGPPeer;

@SdkInternalApi
public class BGPPeerMarshaller {
    private static final MarshallingInfo<Integer> ASN_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").build();
    private static final MarshallingInfo<String> AUTHKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authKey").build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").build();
    private static final MarshallingInfo<String> AMAZONADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amazonAddress").build();
    private static final MarshallingInfo<String> CUSTOMERADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerAddress").build();
    private static final MarshallingInfo<String> BGPPEERSTATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bgpPeerState").build();
    private static final MarshallingInfo<String> BGPSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bgpStatus").build();
    private static final BGPPeerMarshaller instance = new BGPPeerMarshaller();

    public static BGPPeerMarshaller getInstance() {
        return instance;
    }

    public void marshall(BGPPeer bGPPeer, ProtocolMarshaller protocolMarshaller) {
        if (bGPPeer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(bGPPeer.getAsn(), ASN_BINDING);
            protocolMarshaller.marshall(bGPPeer.getAuthKey(), AUTHKEY_BINDING);
            protocolMarshaller.marshall(bGPPeer.getAddressFamily(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall(bGPPeer.getAmazonAddress(), AMAZONADDRESS_BINDING);
            protocolMarshaller.marshall(bGPPeer.getCustomerAddress(), CUSTOMERADDRESS_BINDING);
            protocolMarshaller.marshall(bGPPeer.getBgpPeerState(), BGPPEERSTATE_BINDING);
            protocolMarshaller.marshall(bGPPeer.getBgpStatus(), BGPSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

