/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dax.AmazonDaxAsync;
import com.amazonaws.services.dax.AmazonDaxAsyncClientBuilder;
import com.amazonaws.services.dax.AmazonDaxClient;
import com.amazonaws.services.dax.model.CreateClusterRequest;
import com.amazonaws.services.dax.model.CreateClusterResult;
import com.amazonaws.services.dax.model.CreateParameterGroupRequest;
import com.amazonaws.services.dax.model.CreateParameterGroupResult;
import com.amazonaws.services.dax.model.CreateSubnetGroupRequest;
import com.amazonaws.services.dax.model.CreateSubnetGroupResult;
import com.amazonaws.services.dax.model.DecreaseReplicationFactorRequest;
import com.amazonaws.services.dax.model.DecreaseReplicationFactorResult;
import com.amazonaws.services.dax.model.DeleteClusterRequest;
import com.amazonaws.services.dax.model.DeleteClusterResult;
import com.amazonaws.services.dax.model.DeleteParameterGroupRequest;
import com.amazonaws.services.dax.model.DeleteParameterGroupResult;
import com.amazonaws.services.dax.model.DeleteSubnetGroupRequest;
import com.amazonaws.services.dax.model.DeleteSubnetGroupResult;
import com.amazonaws.services.dax.model.DescribeClustersRequest;
import com.amazonaws.services.dax.model.DescribeClustersResult;
import com.amazonaws.services.dax.model.DescribeDefaultParametersRequest;
import com.amazonaws.services.dax.model.DescribeDefaultParametersResult;
import com.amazonaws.services.dax.model.DescribeEventsRequest;
import com.amazonaws.services.dax.model.DescribeEventsResult;
import com.amazonaws.services.dax.model.DescribeParameterGroupsRequest;
import com.amazonaws.services.dax.model.DescribeParameterGroupsResult;
import com.amazonaws.services.dax.model.DescribeParametersRequest;
import com.amazonaws.services.dax.model.DescribeParametersResult;
import com.amazonaws.services.dax.model.DescribeSubnetGroupsRequest;
import com.amazonaws.services.dax.model.DescribeSubnetGroupsResult;
import com.amazonaws.services.dax.model.IncreaseReplicationFactorRequest;
import com.amazonaws.services.dax.model.IncreaseReplicationFactorResult;
import com.amazonaws.services.dax.model.ListTagsRequest;
import com.amazonaws.services.dax.model.ListTagsResult;
import com.amazonaws.services.dax.model.RebootNodeRequest;
import com.amazonaws.services.dax.model.RebootNodeResult;
import com.amazonaws.services.dax.model.TagResourceRequest;
import com.amazonaws.services.dax.model.TagResourceResult;
import com.amazonaws.services.dax.model.UntagResourceRequest;
import com.amazonaws.services.dax.model.UntagResourceResult;
import com.amazonaws.services.dax.model.UpdateClusterRequest;
import com.amazonaws.services.dax.model.UpdateClusterResult;
import com.amazonaws.services.dax.model.UpdateParameterGroupRequest;
import com.amazonaws.services.dax.model.UpdateParameterGroupResult;
import com.amazonaws.services.dax.model.UpdateSubnetGroupRequest;
import com.amazonaws.services.dax.model.UpdateSubnetGroupResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonDaxAsyncClient
extends AmazonDaxClient
implements AmazonDaxAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonDaxAsyncClientBuilder asyncBuilder() {
        return AmazonDaxAsyncClientBuilder.standard();
    }

    AmazonDaxAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterAsync(request, null);
    }

    @Override
    public Future<CreateClusterResult> createClusterAsync(CreateClusterRequest request, final AsyncHandler<CreateClusterRequest, CreateClusterResult> asyncHandler) {
        final CreateClusterRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateClusterResult>(){

            @Override
            public CreateClusterResult call() throws Exception {
                CreateClusterResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeCreateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateParameterGroupResult> createParameterGroupAsync(CreateParameterGroupRequest request) {
        return this.createParameterGroupAsync(request, null);
    }

    @Override
    public Future<CreateParameterGroupResult> createParameterGroupAsync(CreateParameterGroupRequest request, final AsyncHandler<CreateParameterGroupRequest, CreateParameterGroupResult> asyncHandler) {
        final CreateParameterGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateParameterGroupResult>(){

            @Override
            public CreateParameterGroupResult call() throws Exception {
                CreateParameterGroupResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeCreateParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSubnetGroupResult> createSubnetGroupAsync(CreateSubnetGroupRequest request) {
        return this.createSubnetGroupAsync(request, null);
    }

    @Override
    public Future<CreateSubnetGroupResult> createSubnetGroupAsync(CreateSubnetGroupRequest request, final AsyncHandler<CreateSubnetGroupRequest, CreateSubnetGroupResult> asyncHandler) {
        final CreateSubnetGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSubnetGroupResult>(){

            @Override
            public CreateSubnetGroupResult call() throws Exception {
                CreateSubnetGroupResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeCreateSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DecreaseReplicationFactorResult> decreaseReplicationFactorAsync(DecreaseReplicationFactorRequest request) {
        return this.decreaseReplicationFactorAsync(request, null);
    }

    @Override
    public Future<DecreaseReplicationFactorResult> decreaseReplicationFactorAsync(DecreaseReplicationFactorRequest request, final AsyncHandler<DecreaseReplicationFactorRequest, DecreaseReplicationFactorResult> asyncHandler) {
        final DecreaseReplicationFactorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DecreaseReplicationFactorResult>(){

            @Override
            public DecreaseReplicationFactorResult call() throws Exception {
                DecreaseReplicationFactorResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDecreaseReplicationFactor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterAsync(request, null);
    }

    @Override
    public Future<DeleteClusterResult> deleteClusterAsync(DeleteClusterRequest request, final AsyncHandler<DeleteClusterRequest, DeleteClusterResult> asyncHandler) {
        final DeleteClusterRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteClusterResult>(){

            @Override
            public DeleteClusterResult call() throws Exception {
                DeleteClusterResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDeleteCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteParameterGroupResult> deleteParameterGroupAsync(DeleteParameterGroupRequest request) {
        return this.deleteParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteParameterGroupResult> deleteParameterGroupAsync(DeleteParameterGroupRequest request, final AsyncHandler<DeleteParameterGroupRequest, DeleteParameterGroupResult> asyncHandler) {
        final DeleteParameterGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteParameterGroupResult>(){

            @Override
            public DeleteParameterGroupResult call() throws Exception {
                DeleteParameterGroupResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDeleteParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSubnetGroupResult> deleteSubnetGroupAsync(DeleteSubnetGroupRequest request) {
        return this.deleteSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DeleteSubnetGroupResult> deleteSubnetGroupAsync(DeleteSubnetGroupRequest request, final AsyncHandler<DeleteSubnetGroupRequest, DeleteSubnetGroupResult> asyncHandler) {
        final DeleteSubnetGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSubnetGroupResult>(){

            @Override
            public DeleteSubnetGroupResult call() throws Exception {
                DeleteSubnetGroupResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDeleteSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request) {
        return this.describeClustersAsync(request, null);
    }

    @Override
    public Future<DescribeClustersResult> describeClustersAsync(DescribeClustersRequest request, final AsyncHandler<DescribeClustersRequest, DescribeClustersResult> asyncHandler) {
        final DescribeClustersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeClustersResult>(){

            @Override
            public DescribeClustersResult call() throws Exception {
                DescribeClustersResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDescribeClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDefaultParametersResult> describeDefaultParametersAsync(DescribeDefaultParametersRequest request) {
        return this.describeDefaultParametersAsync(request, null);
    }

    @Override
    public Future<DescribeDefaultParametersResult> describeDefaultParametersAsync(DescribeDefaultParametersRequest request, final AsyncHandler<DescribeDefaultParametersRequest, DescribeDefaultParametersResult> asyncHandler) {
        final DescribeDefaultParametersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDefaultParametersResult>(){

            @Override
            public DescribeDefaultParametersResult call() throws Exception {
                DescribeDefaultParametersResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDescribeDefaultParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        final DescribeEventsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDescribeEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeParameterGroupsResult> describeParameterGroupsAsync(DescribeParameterGroupsRequest request) {
        return this.describeParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeParameterGroupsResult> describeParameterGroupsAsync(DescribeParameterGroupsRequest request, final AsyncHandler<DescribeParameterGroupsRequest, DescribeParameterGroupsResult> asyncHandler) {
        final DescribeParameterGroupsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeParameterGroupsResult>(){

            @Override
            public DescribeParameterGroupsResult call() throws Exception {
                DescribeParameterGroupsResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDescribeParameterGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeParametersResult> describeParametersAsync(DescribeParametersRequest request) {
        return this.describeParametersAsync(request, null);
    }

    @Override
    public Future<DescribeParametersResult> describeParametersAsync(DescribeParametersRequest request, final AsyncHandler<DescribeParametersRequest, DescribeParametersResult> asyncHandler) {
        final DescribeParametersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeParametersResult>(){

            @Override
            public DescribeParametersResult call() throws Exception {
                DescribeParametersResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDescribeParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSubnetGroupsResult> describeSubnetGroupsAsync(DescribeSubnetGroupsRequest request) {
        return this.describeSubnetGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeSubnetGroupsResult> describeSubnetGroupsAsync(DescribeSubnetGroupsRequest request, final AsyncHandler<DescribeSubnetGroupsRequest, DescribeSubnetGroupsResult> asyncHandler) {
        final DescribeSubnetGroupsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSubnetGroupsResult>(){

            @Override
            public DescribeSubnetGroupsResult call() throws Exception {
                DescribeSubnetGroupsResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeDescribeSubnetGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<IncreaseReplicationFactorResult> increaseReplicationFactorAsync(IncreaseReplicationFactorRequest request) {
        return this.increaseReplicationFactorAsync(request, null);
    }

    @Override
    public Future<IncreaseReplicationFactorResult> increaseReplicationFactorAsync(IncreaseReplicationFactorRequest request, final AsyncHandler<IncreaseReplicationFactorRequest, IncreaseReplicationFactorResult> asyncHandler) {
        final IncreaseReplicationFactorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<IncreaseReplicationFactorResult>(){

            @Override
            public IncreaseReplicationFactorResult call() throws Exception {
                IncreaseReplicationFactorResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeIncreaseReplicationFactor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request) {
        return this.listTagsAsync(request, null);
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request, final AsyncHandler<ListTagsRequest, ListTagsResult> asyncHandler) {
        final ListTagsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsResult>(){

            @Override
            public ListTagsResult call() throws Exception {
                ListTagsResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeListTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RebootNodeResult> rebootNodeAsync(RebootNodeRequest request) {
        return this.rebootNodeAsync(request, null);
    }

    @Override
    public Future<RebootNodeResult> rebootNodeAsync(RebootNodeRequest request, final AsyncHandler<RebootNodeRequest, RebootNodeResult> asyncHandler) {
        final RebootNodeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RebootNodeResult>(){

            @Override
            public RebootNodeResult call() throws Exception {
                RebootNodeResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeRebootNode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateClusterResult> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterAsync(request, null);
    }

    @Override
    public Future<UpdateClusterResult> updateClusterAsync(UpdateClusterRequest request, final AsyncHandler<UpdateClusterRequest, UpdateClusterResult> asyncHandler) {
        final UpdateClusterRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateClusterResult>(){

            @Override
            public UpdateClusterResult call() throws Exception {
                UpdateClusterResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeUpdateCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateParameterGroupResult> updateParameterGroupAsync(UpdateParameterGroupRequest request) {
        return this.updateParameterGroupAsync(request, null);
    }

    @Override
    public Future<UpdateParameterGroupResult> updateParameterGroupAsync(UpdateParameterGroupRequest request, final AsyncHandler<UpdateParameterGroupRequest, UpdateParameterGroupResult> asyncHandler) {
        final UpdateParameterGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateParameterGroupResult>(){

            @Override
            public UpdateParameterGroupResult call() throws Exception {
                UpdateParameterGroupResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeUpdateParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSubnetGroupResult> updateSubnetGroupAsync(UpdateSubnetGroupRequest request) {
        return this.updateSubnetGroupAsync(request, null);
    }

    @Override
    public Future<UpdateSubnetGroupResult> updateSubnetGroupAsync(UpdateSubnetGroupRequest request, final AsyncHandler<UpdateSubnetGroupRequest, UpdateSubnetGroupResult> asyncHandler) {
        final UpdateSubnetGroupRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSubnetGroupResult>(){

            @Override
            public UpdateSubnetGroupResult call() throws Exception {
                UpdateSubnetGroupResult result = null;
                try {
                    result = AmazonDaxAsyncClient.this.executeUpdateSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

