/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.TagKeys;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class TagKeysStaxUnmarshaller
implements Unmarshaller<TagKeys, StaxUnmarshallerContext> {
    private static TagKeysStaxUnmarshaller instance;

    @Override
    public TagKeys unmarshall(StaxUnmarshallerContext context) throws Exception {
        TagKeys tagKeys = new TagKeys();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return tagKeys;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Items", targetDepth)) {
                    tagKeys.withItems(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/Key", targetDepth)) continue;
                tagKeys.withItems(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return tagKeys;
    }

    public static TagKeysStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TagKeysStaxUnmarshaller();
        }
        return instance;
    }
}

