/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.ResourceChange;
import com.amazonaws.services.cloudformation.model.ResourceChangeDetail;
import com.amazonaws.services.cloudformation.model.transform.ResourceChangeDetailStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ResourceChangeStaxUnmarshaller
implements Unmarshaller<ResourceChange, StaxUnmarshallerContext> {
    private static ResourceChangeStaxUnmarshaller instance;

    @Override
    public ResourceChange unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceChange resourceChange = new ResourceChange();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceChange;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Action", targetDepth)) {
                    resourceChange.setAction(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LogicalResourceId", targetDepth)) {
                    resourceChange.setLogicalResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PhysicalResourceId", targetDepth)) {
                    resourceChange.setPhysicalResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceType", targetDepth)) {
                    resourceChange.setResourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Replacement", targetDepth)) {
                    resourceChange.setReplacement(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Scope", targetDepth)) {
                    resourceChange.withScope(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Scope/member", targetDepth)) {
                    resourceChange.withScope(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Details", targetDepth)) {
                    resourceChange.withDetails(new ArrayList<ResourceChangeDetail>());
                    continue;
                }
                if (!context.testExpression("Details/member", targetDepth)) continue;
                resourceChange.withDetails(ResourceChangeDetailStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceChange;
    }

    public static ResourceChangeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceChangeStaxUnmarshaller();
        }
        return instance;
    }
}

