/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.AttributeNameAndValue;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import com.amazonaws.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import com.amazonaws.services.clouddirectory.model.transform.TypedLinkSpecifierMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TypedLinkSpecifier
implements Serializable,
Cloneable,
StructuredPojo {
    private TypedLinkSchemaAndFacetName typedLinkFacet;
    private ObjectReference sourceObjectReference;
    private ObjectReference targetObjectReference;
    private List<AttributeNameAndValue> identityAttributeValues;

    public void setTypedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
        this.typedLinkFacet = typedLinkFacet;
    }

    public TypedLinkSchemaAndFacetName getTypedLinkFacet() {
        return this.typedLinkFacet;
    }

    public TypedLinkSpecifier withTypedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
        this.setTypedLinkFacet(typedLinkFacet);
        return this;
    }

    public void setSourceObjectReference(ObjectReference sourceObjectReference) {
        this.sourceObjectReference = sourceObjectReference;
    }

    public ObjectReference getSourceObjectReference() {
        return this.sourceObjectReference;
    }

    public TypedLinkSpecifier withSourceObjectReference(ObjectReference sourceObjectReference) {
        this.setSourceObjectReference(sourceObjectReference);
        return this;
    }

    public void setTargetObjectReference(ObjectReference targetObjectReference) {
        this.targetObjectReference = targetObjectReference;
    }

    public ObjectReference getTargetObjectReference() {
        return this.targetObjectReference;
    }

    public TypedLinkSpecifier withTargetObjectReference(ObjectReference targetObjectReference) {
        this.setTargetObjectReference(targetObjectReference);
        return this;
    }

    public List<AttributeNameAndValue> getIdentityAttributeValues() {
        return this.identityAttributeValues;
    }

    public void setIdentityAttributeValues(Collection<AttributeNameAndValue> identityAttributeValues) {
        if (identityAttributeValues == null) {
            this.identityAttributeValues = null;
            return;
        }
        this.identityAttributeValues = new ArrayList<AttributeNameAndValue>(identityAttributeValues);
    }

    public TypedLinkSpecifier withIdentityAttributeValues(AttributeNameAndValue ... identityAttributeValues) {
        if (this.identityAttributeValues == null) {
            this.setIdentityAttributeValues(new ArrayList<AttributeNameAndValue>(identityAttributeValues.length));
        }
        for (AttributeNameAndValue ele : identityAttributeValues) {
            this.identityAttributeValues.add(ele);
        }
        return this;
    }

    public TypedLinkSpecifier withIdentityAttributeValues(Collection<AttributeNameAndValue> identityAttributeValues) {
        this.setIdentityAttributeValues(identityAttributeValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTypedLinkFacet() != null) {
            sb.append("TypedLinkFacet: ").append(this.getTypedLinkFacet()).append(",");
        }
        if (this.getSourceObjectReference() != null) {
            sb.append("SourceObjectReference: ").append(this.getSourceObjectReference()).append(",");
        }
        if (this.getTargetObjectReference() != null) {
            sb.append("TargetObjectReference: ").append(this.getTargetObjectReference()).append(",");
        }
        if (this.getIdentityAttributeValues() != null) {
            sb.append("IdentityAttributeValues: ").append(this.getIdentityAttributeValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkSpecifier)) {
            return false;
        }
        TypedLinkSpecifier other = (TypedLinkSpecifier)obj;
        if (other.getTypedLinkFacet() == null ^ this.getTypedLinkFacet() == null) {
            return false;
        }
        if (other.getTypedLinkFacet() != null && !other.getTypedLinkFacet().equals(this.getTypedLinkFacet())) {
            return false;
        }
        if (other.getSourceObjectReference() == null ^ this.getSourceObjectReference() == null) {
            return false;
        }
        if (other.getSourceObjectReference() != null && !other.getSourceObjectReference().equals(this.getSourceObjectReference())) {
            return false;
        }
        if (other.getTargetObjectReference() == null ^ this.getTargetObjectReference() == null) {
            return false;
        }
        if (other.getTargetObjectReference() != null && !other.getTargetObjectReference().equals(this.getTargetObjectReference())) {
            return false;
        }
        if (other.getIdentityAttributeValues() == null ^ this.getIdentityAttributeValues() == null) {
            return false;
        }
        return other.getIdentityAttributeValues() == null || other.getIdentityAttributeValues().equals(this.getIdentityAttributeValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTypedLinkFacet() == null ? 0 : this.getTypedLinkFacet().hashCode());
        hashCode = 31 * hashCode + (this.getSourceObjectReference() == null ? 0 : this.getSourceObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.getTargetObjectReference() == null ? 0 : this.getTargetObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityAttributeValues() == null ? 0 : this.getIdentityAttributeValues().hashCode());
        return hashCode;
    }

    public TypedLinkSpecifier clone() {
        try {
            return (TypedLinkSpecifier)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedLinkSpecifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

