/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.clouddirectory.model.ConsistencyLevel;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import com.amazonaws.services.clouddirectory.model.TypedLinkAttributeRange;
import com.amazonaws.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListIncomingTypedLinksRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryArn;
    private ObjectReference objectReference;
    private List<TypedLinkAttributeRange> filterAttributeRanges;
    private TypedLinkSchemaAndFacetName filterTypedLink;
    private String nextToken;
    private Integer maxResults;
    private String consistencyLevel;

    public void setDirectoryArn(String directoryArn) {
        this.directoryArn = directoryArn;
    }

    public String getDirectoryArn() {
        return this.directoryArn;
    }

    public ListIncomingTypedLinksRequest withDirectoryArn(String directoryArn) {
        this.setDirectoryArn(directoryArn);
        return this;
    }

    public void setObjectReference(ObjectReference objectReference) {
        this.objectReference = objectReference;
    }

    public ObjectReference getObjectReference() {
        return this.objectReference;
    }

    public ListIncomingTypedLinksRequest withObjectReference(ObjectReference objectReference) {
        this.setObjectReference(objectReference);
        return this;
    }

    public List<TypedLinkAttributeRange> getFilterAttributeRanges() {
        return this.filterAttributeRanges;
    }

    public void setFilterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges) {
        if (filterAttributeRanges == null) {
            this.filterAttributeRanges = null;
            return;
        }
        this.filterAttributeRanges = new ArrayList<TypedLinkAttributeRange>(filterAttributeRanges);
    }

    public ListIncomingTypedLinksRequest withFilterAttributeRanges(TypedLinkAttributeRange ... filterAttributeRanges) {
        if (this.filterAttributeRanges == null) {
            this.setFilterAttributeRanges(new ArrayList<TypedLinkAttributeRange>(filterAttributeRanges.length));
        }
        for (TypedLinkAttributeRange ele : filterAttributeRanges) {
            this.filterAttributeRanges.add(ele);
        }
        return this;
    }

    public ListIncomingTypedLinksRequest withFilterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges) {
        this.setFilterAttributeRanges(filterAttributeRanges);
        return this;
    }

    public void setFilterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink) {
        this.filterTypedLink = filterTypedLink;
    }

    public TypedLinkSchemaAndFacetName getFilterTypedLink() {
        return this.filterTypedLink;
    }

    public ListIncomingTypedLinksRequest withFilterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink) {
        this.setFilterTypedLink(filterTypedLink);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListIncomingTypedLinksRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListIncomingTypedLinksRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public String getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public ListIncomingTypedLinksRequest withConsistencyLevel(String consistencyLevel) {
        this.setConsistencyLevel(consistencyLevel);
        return this;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel.toString();
    }

    public ListIncomingTypedLinksRequest withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.setConsistencyLevel(consistencyLevel);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.getDirectoryArn()).append(",");
        }
        if (this.getObjectReference() != null) {
            sb.append("ObjectReference: ").append(this.getObjectReference()).append(",");
        }
        if (this.getFilterAttributeRanges() != null) {
            sb.append("FilterAttributeRanges: ").append(this.getFilterAttributeRanges()).append(",");
        }
        if (this.getFilterTypedLink() != null) {
            sb.append("FilterTypedLink: ").append(this.getFilterTypedLink()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getConsistencyLevel() != null) {
            sb.append("ConsistencyLevel: ").append(this.getConsistencyLevel());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIncomingTypedLinksRequest)) {
            return false;
        }
        ListIncomingTypedLinksRequest other = (ListIncomingTypedLinksRequest)obj;
        if (other.getDirectoryArn() == null ^ this.getDirectoryArn() == null) {
            return false;
        }
        if (other.getDirectoryArn() != null && !other.getDirectoryArn().equals(this.getDirectoryArn())) {
            return false;
        }
        if (other.getObjectReference() == null ^ this.getObjectReference() == null) {
            return false;
        }
        if (other.getObjectReference() != null && !other.getObjectReference().equals(this.getObjectReference())) {
            return false;
        }
        if (other.getFilterAttributeRanges() == null ^ this.getFilterAttributeRanges() == null) {
            return false;
        }
        if (other.getFilterAttributeRanges() != null && !other.getFilterAttributeRanges().equals(this.getFilterAttributeRanges())) {
            return false;
        }
        if (other.getFilterTypedLink() == null ^ this.getFilterTypedLink() == null) {
            return false;
        }
        if (other.getFilterTypedLink() != null && !other.getFilterTypedLink().equals(this.getFilterTypedLink())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getConsistencyLevel() == null ^ this.getConsistencyLevel() == null) {
            return false;
        }
        return other.getConsistencyLevel() == null || other.getConsistencyLevel().equals(this.getConsistencyLevel());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryArn() == null ? 0 : this.getDirectoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getObjectReference() == null ? 0 : this.getObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.getFilterAttributeRanges() == null ? 0 : this.getFilterAttributeRanges().hashCode());
        hashCode = 31 * hashCode + (this.getFilterTypedLink() == null ? 0 : this.getFilterTypedLink().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getConsistencyLevel() == null ? 0 : this.getConsistencyLevel().hashCode());
        return hashCode;
    }

    @Override
    public ListIncomingTypedLinksRequest clone() {
        return (ListIncomingTypedLinksRequest)super.clone();
    }
}

