/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.AttributeKeyAndValue;
import com.amazonaws.services.clouddirectory.model.transform.IndexAttachmentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IndexAttachment
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AttributeKeyAndValue> indexedAttributes;
    private String objectIdentifier;

    public List<AttributeKeyAndValue> getIndexedAttributes() {
        return this.indexedAttributes;
    }

    public void setIndexedAttributes(Collection<AttributeKeyAndValue> indexedAttributes) {
        if (indexedAttributes == null) {
            this.indexedAttributes = null;
            return;
        }
        this.indexedAttributes = new ArrayList<AttributeKeyAndValue>(indexedAttributes);
    }

    public IndexAttachment withIndexedAttributes(AttributeKeyAndValue ... indexedAttributes) {
        if (this.indexedAttributes == null) {
            this.setIndexedAttributes(new ArrayList<AttributeKeyAndValue>(indexedAttributes.length));
        }
        for (AttributeKeyAndValue ele : indexedAttributes) {
            this.indexedAttributes.add(ele);
        }
        return this;
    }

    public IndexAttachment withIndexedAttributes(Collection<AttributeKeyAndValue> indexedAttributes) {
        this.setIndexedAttributes(indexedAttributes);
        return this;
    }

    public void setObjectIdentifier(String objectIdentifier) {
        this.objectIdentifier = objectIdentifier;
    }

    public String getObjectIdentifier() {
        return this.objectIdentifier;
    }

    public IndexAttachment withObjectIdentifier(String objectIdentifier) {
        this.setObjectIdentifier(objectIdentifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexedAttributes() != null) {
            sb.append("IndexedAttributes: ").append(this.getIndexedAttributes()).append(",");
        }
        if (this.getObjectIdentifier() != null) {
            sb.append("ObjectIdentifier: ").append(this.getObjectIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexAttachment)) {
            return false;
        }
        IndexAttachment other = (IndexAttachment)obj;
        if (other.getIndexedAttributes() == null ^ this.getIndexedAttributes() == null) {
            return false;
        }
        if (other.getIndexedAttributes() != null && !other.getIndexedAttributes().equals(this.getIndexedAttributes())) {
            return false;
        }
        if (other.getObjectIdentifier() == null ^ this.getObjectIdentifier() == null) {
            return false;
        }
        return other.getObjectIdentifier() == null || other.getObjectIdentifier().equals(this.getObjectIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexedAttributes() == null ? 0 : this.getIndexedAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getObjectIdentifier() == null ? 0 : this.getObjectIdentifier().hashCode());
        return hashCode;
    }

    public IndexAttachment clone() {
        try {
            return (IndexAttachment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IndexAttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

