/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.autoscaling.model.ExecutePolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ExecutePolicyRequestMarshaller
implements Marshaller<Request<ExecutePolicyRequest>, ExecutePolicyRequest> {
    @Override
    public Request<ExecutePolicyRequest> marshall(ExecutePolicyRequest executePolicyRequest) {
        if (executePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ExecutePolicyRequest> request = new DefaultRequest<ExecutePolicyRequest>(executePolicyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "ExecutePolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (executePolicyRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(executePolicyRequest.getAutoScalingGroupName()));
        }
        if (executePolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(executePolicyRequest.getPolicyName()));
        }
        if (executePolicyRequest.getHonorCooldown() != null) {
            request.addParameter("HonorCooldown", StringUtils.fromBoolean(executePolicyRequest.getHonorCooldown()));
        }
        if (executePolicyRequest.getMetricValue() != null) {
            request.addParameter("MetricValue", StringUtils.fromDouble(executePolicyRequest.getMetricValue()));
        }
        if (executePolicyRequest.getBreachThreshold() != null) {
            request.addParameter("BreachThreshold", StringUtils.fromDouble(executePolicyRequest.getBreachThreshold()));
        }
        return request;
    }
}

