/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.braket.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.braket.model.AlgorithmSpecification;
import com.amazonaws.services.braket.model.DeviceConfig;
import com.amazonaws.services.braket.model.InputFileConfig;
import com.amazonaws.services.braket.model.InstanceConfig;
import com.amazonaws.services.braket.model.JobCheckpointConfig;
import com.amazonaws.services.braket.model.JobOutputDataConfig;
import com.amazonaws.services.braket.model.JobStoppingCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private AlgorithmSpecification algorithmSpecification;
    private JobCheckpointConfig checkpointConfig;
    private String clientToken;
    private DeviceConfig deviceConfig;
    private Map<String, String> hyperParameters;
    private List<InputFileConfig> inputDataConfig;
    private InstanceConfig instanceConfig;
    private String jobName;
    private JobOutputDataConfig outputDataConfig;
    private String roleArn;
    private JobStoppingCondition stoppingCondition;
    private Map<String, String> tags;

    public void setAlgorithmSpecification(AlgorithmSpecification algorithmSpecification) {
        this.algorithmSpecification = algorithmSpecification;
    }

    public AlgorithmSpecification getAlgorithmSpecification() {
        return this.algorithmSpecification;
    }

    public CreateJobRequest withAlgorithmSpecification(AlgorithmSpecification algorithmSpecification) {
        this.setAlgorithmSpecification(algorithmSpecification);
        return this;
    }

    public void setCheckpointConfig(JobCheckpointConfig checkpointConfig) {
        this.checkpointConfig = checkpointConfig;
    }

    public JobCheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public CreateJobRequest withCheckpointConfig(JobCheckpointConfig checkpointConfig) {
        this.setCheckpointConfig(checkpointConfig);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateJobRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDeviceConfig(DeviceConfig deviceConfig) {
        this.deviceConfig = deviceConfig;
    }

    public DeviceConfig getDeviceConfig() {
        return this.deviceConfig;
    }

    public CreateJobRequest withDeviceConfig(DeviceConfig deviceConfig) {
        this.setDeviceConfig(deviceConfig);
        return this;
    }

    public Map<String, String> getHyperParameters() {
        return this.hyperParameters;
    }

    public void setHyperParameters(Map<String, String> hyperParameters) {
        this.hyperParameters = hyperParameters;
    }

    public CreateJobRequest withHyperParameters(Map<String, String> hyperParameters) {
        this.setHyperParameters(hyperParameters);
        return this;
    }

    public CreateJobRequest addHyperParametersEntry(String key, String value) {
        if (null == this.hyperParameters) {
            this.hyperParameters = new HashMap<String, String>();
        }
        if (this.hyperParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.hyperParameters.put(key, value);
        return this;
    }

    public CreateJobRequest clearHyperParametersEntries() {
        this.hyperParameters = null;
        return this;
    }

    public List<InputFileConfig> getInputDataConfig() {
        return this.inputDataConfig;
    }

    public void setInputDataConfig(Collection<InputFileConfig> inputDataConfig) {
        if (inputDataConfig == null) {
            this.inputDataConfig = null;
            return;
        }
        this.inputDataConfig = new ArrayList<InputFileConfig>(inputDataConfig);
    }

    public CreateJobRequest withInputDataConfig(InputFileConfig ... inputDataConfig) {
        if (this.inputDataConfig == null) {
            this.setInputDataConfig(new ArrayList<InputFileConfig>(inputDataConfig.length));
        }
        for (InputFileConfig ele : inputDataConfig) {
            this.inputDataConfig.add(ele);
        }
        return this;
    }

    public CreateJobRequest withInputDataConfig(Collection<InputFileConfig> inputDataConfig) {
        this.setInputDataConfig(inputDataConfig);
        return this;
    }

    public void setInstanceConfig(InstanceConfig instanceConfig) {
        this.instanceConfig = instanceConfig;
    }

    public InstanceConfig getInstanceConfig() {
        return this.instanceConfig;
    }

    public CreateJobRequest withInstanceConfig(InstanceConfig instanceConfig) {
        this.setInstanceConfig(instanceConfig);
        return this;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public CreateJobRequest withJobName(String jobName) {
        this.setJobName(jobName);
        return this;
    }

    public void setOutputDataConfig(JobOutputDataConfig outputDataConfig) {
        this.outputDataConfig = outputDataConfig;
    }

    public JobOutputDataConfig getOutputDataConfig() {
        return this.outputDataConfig;
    }

    public CreateJobRequest withOutputDataConfig(JobOutputDataConfig outputDataConfig) {
        this.setOutputDataConfig(outputDataConfig);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateJobRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setStoppingCondition(JobStoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public JobStoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public CreateJobRequest withStoppingCondition(JobStoppingCondition stoppingCondition) {
        this.setStoppingCondition(stoppingCondition);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateJobRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateJobRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateJobRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithmSpecification() != null) {
            sb.append("AlgorithmSpecification: ").append(this.getAlgorithmSpecification()).append(",");
        }
        if (this.getCheckpointConfig() != null) {
            sb.append("CheckpointConfig: ").append(this.getCheckpointConfig()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDeviceConfig() != null) {
            sb.append("DeviceConfig: ").append(this.getDeviceConfig()).append(",");
        }
        if (this.getHyperParameters() != null) {
            sb.append("HyperParameters: ").append(this.getHyperParameters()).append(",");
        }
        if (this.getInputDataConfig() != null) {
            sb.append("InputDataConfig: ").append(this.getInputDataConfig()).append(",");
        }
        if (this.getInstanceConfig() != null) {
            sb.append("InstanceConfig: ").append(this.getInstanceConfig()).append(",");
        }
        if (this.getJobName() != null) {
            sb.append("JobName: ").append(this.getJobName()).append(",");
        }
        if (this.getOutputDataConfig() != null) {
            sb.append("OutputDataConfig: ").append(this.getOutputDataConfig()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getStoppingCondition() != null) {
            sb.append("StoppingCondition: ").append(this.getStoppingCondition()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)obj;
        if (other.getAlgorithmSpecification() == null ^ this.getAlgorithmSpecification() == null) {
            return false;
        }
        if (other.getAlgorithmSpecification() != null && !other.getAlgorithmSpecification().equals(this.getAlgorithmSpecification())) {
            return false;
        }
        if (other.getCheckpointConfig() == null ^ this.getCheckpointConfig() == null) {
            return false;
        }
        if (other.getCheckpointConfig() != null && !other.getCheckpointConfig().equals(this.getCheckpointConfig())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDeviceConfig() == null ^ this.getDeviceConfig() == null) {
            return false;
        }
        if (other.getDeviceConfig() != null && !other.getDeviceConfig().equals(this.getDeviceConfig())) {
            return false;
        }
        if (other.getHyperParameters() == null ^ this.getHyperParameters() == null) {
            return false;
        }
        if (other.getHyperParameters() != null && !other.getHyperParameters().equals(this.getHyperParameters())) {
            return false;
        }
        if (other.getInputDataConfig() == null ^ this.getInputDataConfig() == null) {
            return false;
        }
        if (other.getInputDataConfig() != null && !other.getInputDataConfig().equals(this.getInputDataConfig())) {
            return false;
        }
        if (other.getInstanceConfig() == null ^ this.getInstanceConfig() == null) {
            return false;
        }
        if (other.getInstanceConfig() != null && !other.getInstanceConfig().equals(this.getInstanceConfig())) {
            return false;
        }
        if (other.getJobName() == null ^ this.getJobName() == null) {
            return false;
        }
        if (other.getJobName() != null && !other.getJobName().equals(this.getJobName())) {
            return false;
        }
        if (other.getOutputDataConfig() == null ^ this.getOutputDataConfig() == null) {
            return false;
        }
        if (other.getOutputDataConfig() != null && !other.getOutputDataConfig().equals(this.getOutputDataConfig())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getStoppingCondition() == null ^ this.getStoppingCondition() == null) {
            return false;
        }
        if (other.getStoppingCondition() != null && !other.getStoppingCondition().equals(this.getStoppingCondition())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithmSpecification() == null ? 0 : this.getAlgorithmSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getCheckpointConfig() == null ? 0 : this.getCheckpointConfig().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceConfig() == null ? 0 : this.getDeviceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getHyperParameters() == null ? 0 : this.getHyperParameters().hashCode());
        hashCode = 31 * hashCode + (this.getInputDataConfig() == null ? 0 : this.getInputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceConfig() == null ? 0 : this.getInstanceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getJobName() == null ? 0 : this.getJobName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDataConfig() == null ? 0 : this.getOutputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingCondition() == null ? 0 : this.getStoppingCondition().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateJobRequest clone() {
        return (CreateJobRequest)super.clone();
    }
}

