/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.billingconductor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.billingconductor.model.PricingPlanListElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPricingPlansResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String billingPeriod;
    private List<PricingPlanListElement> pricingPlans;
    private String nextToken;

    public void setBillingPeriod(String billingPeriod) {
        this.billingPeriod = billingPeriod;
    }

    public String getBillingPeriod() {
        return this.billingPeriod;
    }

    public ListPricingPlansResult withBillingPeriod(String billingPeriod) {
        this.setBillingPeriod(billingPeriod);
        return this;
    }

    public List<PricingPlanListElement> getPricingPlans() {
        return this.pricingPlans;
    }

    public void setPricingPlans(Collection<PricingPlanListElement> pricingPlans) {
        if (pricingPlans == null) {
            this.pricingPlans = null;
            return;
        }
        this.pricingPlans = new ArrayList<PricingPlanListElement>(pricingPlans);
    }

    public ListPricingPlansResult withPricingPlans(PricingPlanListElement ... pricingPlans) {
        if (this.pricingPlans == null) {
            this.setPricingPlans(new ArrayList<PricingPlanListElement>(pricingPlans.length));
        }
        for (PricingPlanListElement ele : pricingPlans) {
            this.pricingPlans.add(ele);
        }
        return this;
    }

    public ListPricingPlansResult withPricingPlans(Collection<PricingPlanListElement> pricingPlans) {
        this.setPricingPlans(pricingPlans);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPricingPlansResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBillingPeriod() != null) {
            sb.append("BillingPeriod: ").append(this.getBillingPeriod()).append(",");
        }
        if (this.getPricingPlans() != null) {
            sb.append("PricingPlans: ").append(this.getPricingPlans()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingPlansResult)) {
            return false;
        }
        ListPricingPlansResult other = (ListPricingPlansResult)obj;
        if (other.getBillingPeriod() == null ^ this.getBillingPeriod() == null) {
            return false;
        }
        if (other.getBillingPeriod() != null && !other.getBillingPeriod().equals(this.getBillingPeriod())) {
            return false;
        }
        if (other.getPricingPlans() == null ^ this.getPricingPlans() == null) {
            return false;
        }
        if (other.getPricingPlans() != null && !other.getPricingPlans().equals(this.getPricingPlans())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBillingPeriod() == null ? 0 : this.getBillingPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getPricingPlans() == null ? 0 : this.getPricingPlans().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPricingPlansResult clone() {
        try {
            return (ListPricingPlansResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

