/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscalingplans.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.autoscalingplans.model.ScalableDimension;
import com.amazonaws.services.autoscalingplans.model.ScalingPolicy;
import com.amazonaws.services.autoscalingplans.model.ScalingStatusCode;
import com.amazonaws.services.autoscalingplans.model.ServiceNamespace;
import com.amazonaws.services.autoscalingplans.model.transform.ScalingPlanResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScalingPlanResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String scalingPlanName;
    private Long scalingPlanVersion;
    private String serviceNamespace;
    private String resourceId;
    private String scalableDimension;
    private List<ScalingPolicy> scalingPolicies;
    private String scalingStatusCode;
    private String scalingStatusMessage;

    public void setScalingPlanName(String scalingPlanName) {
        this.scalingPlanName = scalingPlanName;
    }

    public String getScalingPlanName() {
        return this.scalingPlanName;
    }

    public ScalingPlanResource withScalingPlanName(String scalingPlanName) {
        this.setScalingPlanName(scalingPlanName);
        return this;
    }

    public void setScalingPlanVersion(Long scalingPlanVersion) {
        this.scalingPlanVersion = scalingPlanVersion;
    }

    public Long getScalingPlanVersion() {
        return this.scalingPlanVersion;
    }

    public ScalingPlanResource withScalingPlanVersion(Long scalingPlanVersion) {
        this.setScalingPlanVersion(scalingPlanVersion);
        return this;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this.serviceNamespace = serviceNamespace;
    }

    public String getServiceNamespace() {
        return this.serviceNamespace;
    }

    public ScalingPlanResource withServiceNamespace(String serviceNamespace) {
        this.setServiceNamespace(serviceNamespace);
        return this;
    }

    public ScalingPlanResource withServiceNamespace(ServiceNamespace serviceNamespace) {
        this.serviceNamespace = serviceNamespace.toString();
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ScalingPlanResource withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setScalableDimension(String scalableDimension) {
        this.scalableDimension = scalableDimension;
    }

    public String getScalableDimension() {
        return this.scalableDimension;
    }

    public ScalingPlanResource withScalableDimension(String scalableDimension) {
        this.setScalableDimension(scalableDimension);
        return this;
    }

    public ScalingPlanResource withScalableDimension(ScalableDimension scalableDimension) {
        this.scalableDimension = scalableDimension.toString();
        return this;
    }

    public List<ScalingPolicy> getScalingPolicies() {
        return this.scalingPolicies;
    }

    public void setScalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
        if (scalingPolicies == null) {
            this.scalingPolicies = null;
            return;
        }
        this.scalingPolicies = new ArrayList<ScalingPolicy>(scalingPolicies);
    }

    public ScalingPlanResource withScalingPolicies(ScalingPolicy ... scalingPolicies) {
        if (this.scalingPolicies == null) {
            this.setScalingPolicies(new ArrayList<ScalingPolicy>(scalingPolicies.length));
        }
        for (ScalingPolicy ele : scalingPolicies) {
            this.scalingPolicies.add(ele);
        }
        return this;
    }

    public ScalingPlanResource withScalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
        this.setScalingPolicies(scalingPolicies);
        return this;
    }

    public void setScalingStatusCode(String scalingStatusCode) {
        this.scalingStatusCode = scalingStatusCode;
    }

    public String getScalingStatusCode() {
        return this.scalingStatusCode;
    }

    public ScalingPlanResource withScalingStatusCode(String scalingStatusCode) {
        this.setScalingStatusCode(scalingStatusCode);
        return this;
    }

    public ScalingPlanResource withScalingStatusCode(ScalingStatusCode scalingStatusCode) {
        this.scalingStatusCode = scalingStatusCode.toString();
        return this;
    }

    public void setScalingStatusMessage(String scalingStatusMessage) {
        this.scalingStatusMessage = scalingStatusMessage;
    }

    public String getScalingStatusMessage() {
        return this.scalingStatusMessage;
    }

    public ScalingPlanResource withScalingStatusMessage(String scalingStatusMessage) {
        this.setScalingStatusMessage(scalingStatusMessage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScalingPlanName() != null) {
            sb.append("ScalingPlanName: ").append(this.getScalingPlanName()).append(",");
        }
        if (this.getScalingPlanVersion() != null) {
            sb.append("ScalingPlanVersion: ").append(this.getScalingPlanVersion()).append(",");
        }
        if (this.getServiceNamespace() != null) {
            sb.append("ServiceNamespace: ").append(this.getServiceNamespace()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getScalableDimension() != null) {
            sb.append("ScalableDimension: ").append(this.getScalableDimension()).append(",");
        }
        if (this.getScalingPolicies() != null) {
            sb.append("ScalingPolicies: ").append(this.getScalingPolicies()).append(",");
        }
        if (this.getScalingStatusCode() != null) {
            sb.append("ScalingStatusCode: ").append(this.getScalingStatusCode()).append(",");
        }
        if (this.getScalingStatusMessage() != null) {
            sb.append("ScalingStatusMessage: ").append(this.getScalingStatusMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPlanResource)) {
            return false;
        }
        ScalingPlanResource other = (ScalingPlanResource)obj;
        if (other.getScalingPlanName() == null ^ this.getScalingPlanName() == null) {
            return false;
        }
        if (other.getScalingPlanName() != null && !other.getScalingPlanName().equals(this.getScalingPlanName())) {
            return false;
        }
        if (other.getScalingPlanVersion() == null ^ this.getScalingPlanVersion() == null) {
            return false;
        }
        if (other.getScalingPlanVersion() != null && !other.getScalingPlanVersion().equals(this.getScalingPlanVersion())) {
            return false;
        }
        if (other.getServiceNamespace() == null ^ this.getServiceNamespace() == null) {
            return false;
        }
        if (other.getServiceNamespace() != null && !other.getServiceNamespace().equals(this.getServiceNamespace())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getScalableDimension() == null ^ this.getScalableDimension() == null) {
            return false;
        }
        if (other.getScalableDimension() != null && !other.getScalableDimension().equals(this.getScalableDimension())) {
            return false;
        }
        if (other.getScalingPolicies() == null ^ this.getScalingPolicies() == null) {
            return false;
        }
        if (other.getScalingPolicies() != null && !other.getScalingPolicies().equals(this.getScalingPolicies())) {
            return false;
        }
        if (other.getScalingStatusCode() == null ^ this.getScalingStatusCode() == null) {
            return false;
        }
        if (other.getScalingStatusCode() != null && !other.getScalingStatusCode().equals(this.getScalingStatusCode())) {
            return false;
        }
        if (other.getScalingStatusMessage() == null ^ this.getScalingStatusMessage() == null) {
            return false;
        }
        return other.getScalingStatusMessage() == null || other.getScalingStatusMessage().equals(this.getScalingStatusMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScalingPlanName() == null ? 0 : this.getScalingPlanName().hashCode());
        hashCode = 31 * hashCode + (this.getScalingPlanVersion() == null ? 0 : this.getScalingPlanVersion().hashCode());
        hashCode = 31 * hashCode + (this.getServiceNamespace() == null ? 0 : this.getServiceNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getScalableDimension() == null ? 0 : this.getScalableDimension().hashCode());
        hashCode = 31 * hashCode + (this.getScalingPolicies() == null ? 0 : this.getScalingPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getScalingStatusCode() == null ? 0 : this.getScalingStatusCode().hashCode());
        hashCode = 31 * hashCode + (this.getScalingStatusMessage() == null ? 0 : this.getScalingStatusMessage().hashCode());
        return hashCode;
    }

    public ScalingPlanResource clone() {
        try {
            return (ScalingPlanResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingPlanResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

