/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SetDesiredCapacityRequestMarshaller
implements Marshaller<Request<SetDesiredCapacityRequest>, SetDesiredCapacityRequest> {
    public Request<SetDesiredCapacityRequest> marshall(SetDesiredCapacityRequest setDesiredCapacityRequest) {
        if (setDesiredCapacityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setDesiredCapacityRequest, "AmazonAutoScaling");
        request.addParameter("Action", "SetDesiredCapacity");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setDesiredCapacityRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)setDesiredCapacityRequest.getAutoScalingGroupName()));
        }
        if (setDesiredCapacityRequest.getDesiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)setDesiredCapacityRequest.getDesiredCapacity()));
        }
        if (setDesiredCapacityRequest.getHonorCooldown() != null) {
            request.addParameter("HonorCooldown", StringUtils.fromBoolean((Boolean)setDesiredCapacityRequest.getHonorCooldown()));
        }
        return request;
    }
}

