/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appsync.model.DataSource;

@SdkInternalApi
public class DataSourceMarshaller {
    private static final MarshallingInfo<String> DATASOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSourceArn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceRoleArn").build();
    private static final MarshallingInfo<StructuredPojo> DYNAMODBCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamodbConfig").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambdaConfig").build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("elasticsearchConfig").build();
    private static final DataSourceMarshaller instance = new DataSourceMarshaller();

    public static DataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSource dataSource, ProtocolMarshaller protocolMarshaller) {
        if (dataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSource.getDataSourceArn(), DATASOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getServiceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getDynamodbConfig(), DYNAMODBCONFIG_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getLambdaConfig(), LAMBDACONFIG_BINDING);
            protocolMarshaller.marshall((Object)dataSource.getElasticsearchConfig(), ELASTICSEARCHCONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

