/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apprunner.model.ImageConfiguration;
import java.util.Map;

@SdkInternalApi
public class ImageConfigurationMarshaller {
    private static final MarshallingInfo<Map> RUNTIMEENVIRONMENTVARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuntimeEnvironmentVariables").build();
    private static final MarshallingInfo<String> STARTCOMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartCommand").build();
    private static final MarshallingInfo<String> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").build();
    private static final ImageConfigurationMarshaller instance = new ImageConfigurationMarshaller();

    public static ImageConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageConfiguration imageConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (imageConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(imageConfiguration.getRuntimeEnvironmentVariables(), RUNTIMEENVIRONMENTVARIABLES_BINDING);
            protocolMarshaller.marshall((Object)imageConfiguration.getStartCommand(), STARTCOMMAND_BINDING);
            protocolMarshaller.marshall((Object)imageConfiguration.getPort(), PORT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

