/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appregistry;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.appregistry.AWSAppRegistryAsync;
import com.amazonaws.services.appregistry.AWSAppRegistryAsyncClientBuilder;
import com.amazonaws.services.appregistry.AWSAppRegistryClient;
import com.amazonaws.services.appregistry.model.AssociateAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.AssociateAttributeGroupResult;
import com.amazonaws.services.appregistry.model.AssociateResourceRequest;
import com.amazonaws.services.appregistry.model.AssociateResourceResult;
import com.amazonaws.services.appregistry.model.CreateApplicationRequest;
import com.amazonaws.services.appregistry.model.CreateApplicationResult;
import com.amazonaws.services.appregistry.model.CreateAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.CreateAttributeGroupResult;
import com.amazonaws.services.appregistry.model.DeleteApplicationRequest;
import com.amazonaws.services.appregistry.model.DeleteApplicationResult;
import com.amazonaws.services.appregistry.model.DeleteAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.DeleteAttributeGroupResult;
import com.amazonaws.services.appregistry.model.DisassociateAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.DisassociateAttributeGroupResult;
import com.amazonaws.services.appregistry.model.DisassociateResourceRequest;
import com.amazonaws.services.appregistry.model.DisassociateResourceResult;
import com.amazonaws.services.appregistry.model.GetApplicationRequest;
import com.amazonaws.services.appregistry.model.GetApplicationResult;
import com.amazonaws.services.appregistry.model.GetAssociatedResourceRequest;
import com.amazonaws.services.appregistry.model.GetAssociatedResourceResult;
import com.amazonaws.services.appregistry.model.GetAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.GetAttributeGroupResult;
import com.amazonaws.services.appregistry.model.ListApplicationsRequest;
import com.amazonaws.services.appregistry.model.ListApplicationsResult;
import com.amazonaws.services.appregistry.model.ListAssociatedAttributeGroupsRequest;
import com.amazonaws.services.appregistry.model.ListAssociatedAttributeGroupsResult;
import com.amazonaws.services.appregistry.model.ListAssociatedResourcesRequest;
import com.amazonaws.services.appregistry.model.ListAssociatedResourcesResult;
import com.amazonaws.services.appregistry.model.ListAttributeGroupsForApplicationRequest;
import com.amazonaws.services.appregistry.model.ListAttributeGroupsForApplicationResult;
import com.amazonaws.services.appregistry.model.ListAttributeGroupsRequest;
import com.amazonaws.services.appregistry.model.ListAttributeGroupsResult;
import com.amazonaws.services.appregistry.model.ListTagsForResourceRequest;
import com.amazonaws.services.appregistry.model.ListTagsForResourceResult;
import com.amazonaws.services.appregistry.model.SyncResourceRequest;
import com.amazonaws.services.appregistry.model.SyncResourceResult;
import com.amazonaws.services.appregistry.model.TagResourceRequest;
import com.amazonaws.services.appregistry.model.TagResourceResult;
import com.amazonaws.services.appregistry.model.UntagResourceRequest;
import com.amazonaws.services.appregistry.model.UntagResourceResult;
import com.amazonaws.services.appregistry.model.UpdateApplicationRequest;
import com.amazonaws.services.appregistry.model.UpdateApplicationResult;
import com.amazonaws.services.appregistry.model.UpdateAttributeGroupRequest;
import com.amazonaws.services.appregistry.model.UpdateAttributeGroupResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSAppRegistryAsyncClient
extends AWSAppRegistryClient
implements AWSAppRegistryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSAppRegistryAsyncClientBuilder asyncBuilder() {
        return AWSAppRegistryAsyncClientBuilder.standard();
    }

    AWSAppRegistryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSAppRegistryAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateAttributeGroupResult> associateAttributeGroupAsync(AssociateAttributeGroupRequest request) {
        return this.associateAttributeGroupAsync(request, null);
    }

    @Override
    public Future<AssociateAttributeGroupResult> associateAttributeGroupAsync(AssociateAttributeGroupRequest request, final AsyncHandler<AssociateAttributeGroupRequest, AssociateAttributeGroupResult> asyncHandler) {
        final AssociateAttributeGroupRequest finalRequest = (AssociateAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateAttributeGroupResult>(){

            @Override
            public AssociateAttributeGroupResult call() throws Exception {
                AssociateAttributeGroupResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeAssociateAttributeGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateResourceResult> associateResourceAsync(AssociateResourceRequest request) {
        return this.associateResourceAsync(request, null);
    }

    @Override
    public Future<AssociateResourceResult> associateResourceAsync(AssociateResourceRequest request, final AsyncHandler<AssociateResourceRequest, AssociateResourceResult> asyncHandler) {
        final AssociateResourceRequest finalRequest = (AssociateResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateResourceResult>(){

            @Override
            public AssociateResourceResult call() throws Exception {
                AssociateResourceResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeAssociateResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        final CreateApplicationRequest finalRequest = (CreateApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeCreateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAttributeGroupResult> createAttributeGroupAsync(CreateAttributeGroupRequest request) {
        return this.createAttributeGroupAsync(request, null);
    }

    @Override
    public Future<CreateAttributeGroupResult> createAttributeGroupAsync(CreateAttributeGroupRequest request, final AsyncHandler<CreateAttributeGroupRequest, CreateAttributeGroupResult> asyncHandler) {
        final CreateAttributeGroupRequest finalRequest = (CreateAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAttributeGroupResult>(){

            @Override
            public CreateAttributeGroupResult call() throws Exception {
                CreateAttributeGroupResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeCreateAttributeGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request, final AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler) {
        final DeleteApplicationRequest finalRequest = (DeleteApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteApplicationResult>(){

            @Override
            public DeleteApplicationResult call() throws Exception {
                DeleteApplicationResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeDeleteApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAttributeGroupResult> deleteAttributeGroupAsync(DeleteAttributeGroupRequest request) {
        return this.deleteAttributeGroupAsync(request, null);
    }

    @Override
    public Future<DeleteAttributeGroupResult> deleteAttributeGroupAsync(DeleteAttributeGroupRequest request, final AsyncHandler<DeleteAttributeGroupRequest, DeleteAttributeGroupResult> asyncHandler) {
        final DeleteAttributeGroupRequest finalRequest = (DeleteAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAttributeGroupResult>(){

            @Override
            public DeleteAttributeGroupResult call() throws Exception {
                DeleteAttributeGroupResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeDeleteAttributeGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateAttributeGroupResult> disassociateAttributeGroupAsync(DisassociateAttributeGroupRequest request) {
        return this.disassociateAttributeGroupAsync(request, null);
    }

    @Override
    public Future<DisassociateAttributeGroupResult> disassociateAttributeGroupAsync(DisassociateAttributeGroupRequest request, final AsyncHandler<DisassociateAttributeGroupRequest, DisassociateAttributeGroupResult> asyncHandler) {
        final DisassociateAttributeGroupRequest finalRequest = (DisassociateAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateAttributeGroupResult>(){

            @Override
            public DisassociateAttributeGroupResult call() throws Exception {
                DisassociateAttributeGroupResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeDisassociateAttributeGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateResourceResult> disassociateResourceAsync(DisassociateResourceRequest request) {
        return this.disassociateResourceAsync(request, null);
    }

    @Override
    public Future<DisassociateResourceResult> disassociateResourceAsync(DisassociateResourceRequest request, final AsyncHandler<DisassociateResourceRequest, DisassociateResourceResult> asyncHandler) {
        final DisassociateResourceRequest finalRequest = (DisassociateResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateResourceResult>(){

            @Override
            public DisassociateResourceResult call() throws Exception {
                DisassociateResourceResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeDisassociateResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request) {
        return this.getApplicationAsync(request, null);
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request, final AsyncHandler<GetApplicationRequest, GetApplicationResult> asyncHandler) {
        final GetApplicationRequest finalRequest = (GetApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetApplicationResult>(){

            @Override
            public GetApplicationResult call() throws Exception {
                GetApplicationResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeGetApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAssociatedResourceResult> getAssociatedResourceAsync(GetAssociatedResourceRequest request) {
        return this.getAssociatedResourceAsync(request, null);
    }

    @Override
    public Future<GetAssociatedResourceResult> getAssociatedResourceAsync(GetAssociatedResourceRequest request, final AsyncHandler<GetAssociatedResourceRequest, GetAssociatedResourceResult> asyncHandler) {
        final GetAssociatedResourceRequest finalRequest = (GetAssociatedResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAssociatedResourceResult>(){

            @Override
            public GetAssociatedResourceResult call() throws Exception {
                GetAssociatedResourceResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeGetAssociatedResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAttributeGroupResult> getAttributeGroupAsync(GetAttributeGroupRequest request) {
        return this.getAttributeGroupAsync(request, null);
    }

    @Override
    public Future<GetAttributeGroupResult> getAttributeGroupAsync(GetAttributeGroupRequest request, final AsyncHandler<GetAttributeGroupRequest, GetAttributeGroupResult> asyncHandler) {
        final GetAttributeGroupRequest finalRequest = (GetAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAttributeGroupResult>(){

            @Override
            public GetAttributeGroupResult call() throws Exception {
                GetAttributeGroupResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeGetAttributeGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {
        return this.listApplicationsAsync(request, null);
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request, final AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        final ListApplicationsRequest finalRequest = (ListApplicationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationsResult>(){

            @Override
            public ListApplicationsResult call() throws Exception {
                ListApplicationsResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeListApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssociatedAttributeGroupsResult> listAssociatedAttributeGroupsAsync(ListAssociatedAttributeGroupsRequest request) {
        return this.listAssociatedAttributeGroupsAsync(request, null);
    }

    @Override
    public Future<ListAssociatedAttributeGroupsResult> listAssociatedAttributeGroupsAsync(ListAssociatedAttributeGroupsRequest request, final AsyncHandler<ListAssociatedAttributeGroupsRequest, ListAssociatedAttributeGroupsResult> asyncHandler) {
        final ListAssociatedAttributeGroupsRequest finalRequest = (ListAssociatedAttributeGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssociatedAttributeGroupsResult>(){

            @Override
            public ListAssociatedAttributeGroupsResult call() throws Exception {
                ListAssociatedAttributeGroupsResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeListAssociatedAttributeGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssociatedResourcesResult> listAssociatedResourcesAsync(ListAssociatedResourcesRequest request) {
        return this.listAssociatedResourcesAsync(request, null);
    }

    @Override
    public Future<ListAssociatedResourcesResult> listAssociatedResourcesAsync(ListAssociatedResourcesRequest request, final AsyncHandler<ListAssociatedResourcesRequest, ListAssociatedResourcesResult> asyncHandler) {
        final ListAssociatedResourcesRequest finalRequest = (ListAssociatedResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssociatedResourcesResult>(){

            @Override
            public ListAssociatedResourcesResult call() throws Exception {
                ListAssociatedResourcesResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeListAssociatedResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAttributeGroupsResult> listAttributeGroupsAsync(ListAttributeGroupsRequest request) {
        return this.listAttributeGroupsAsync(request, null);
    }

    @Override
    public Future<ListAttributeGroupsResult> listAttributeGroupsAsync(ListAttributeGroupsRequest request, final AsyncHandler<ListAttributeGroupsRequest, ListAttributeGroupsResult> asyncHandler) {
        final ListAttributeGroupsRequest finalRequest = (ListAttributeGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAttributeGroupsResult>(){

            @Override
            public ListAttributeGroupsResult call() throws Exception {
                ListAttributeGroupsResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeListAttributeGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAttributeGroupsForApplicationResult> listAttributeGroupsForApplicationAsync(ListAttributeGroupsForApplicationRequest request) {
        return this.listAttributeGroupsForApplicationAsync(request, null);
    }

    @Override
    public Future<ListAttributeGroupsForApplicationResult> listAttributeGroupsForApplicationAsync(ListAttributeGroupsForApplicationRequest request, final AsyncHandler<ListAttributeGroupsForApplicationRequest, ListAttributeGroupsForApplicationResult> asyncHandler) {
        final ListAttributeGroupsForApplicationRequest finalRequest = (ListAttributeGroupsForApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAttributeGroupsForApplicationResult>(){

            @Override
            public ListAttributeGroupsForApplicationResult call() throws Exception {
                ListAttributeGroupsForApplicationResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeListAttributeGroupsForApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SyncResourceResult> syncResourceAsync(SyncResourceRequest request) {
        return this.syncResourceAsync(request, null);
    }

    @Override
    public Future<SyncResourceResult> syncResourceAsync(SyncResourceRequest request, final AsyncHandler<SyncResourceRequest, SyncResourceResult> asyncHandler) {
        final SyncResourceRequest finalRequest = (SyncResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SyncResourceResult>(){

            @Override
            public SyncResourceResult call() throws Exception {
                SyncResourceResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeSyncResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request, final AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {
        final UpdateApplicationRequest finalRequest = (UpdateApplicationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                UpdateApplicationResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeUpdateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAttributeGroupResult> updateAttributeGroupAsync(UpdateAttributeGroupRequest request) {
        return this.updateAttributeGroupAsync(request, null);
    }

    @Override
    public Future<UpdateAttributeGroupResult> updateAttributeGroupAsync(UpdateAttributeGroupRequest request, final AsyncHandler<UpdateAttributeGroupRequest, UpdateAttributeGroupResult> asyncHandler) {
        final UpdateAttributeGroupRequest finalRequest = (UpdateAttributeGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAttributeGroupResult>(){

            @Override
            public UpdateAttributeGroupResult call() throws Exception {
                UpdateAttributeGroupResult result = null;
                try {
                    result = AWSAppRegistryAsyncClient.this.executeUpdateAttributeGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

