/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationcostprofiler.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationcostprofiler.model.S3BucketRegion;
import com.amazonaws.services.applicationcostprofiler.model.transform.SourceS3LocationMarshaller;
import java.io.Serializable;

public class SourceS3Location
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucket;
    private String key;
    private String region;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public SourceS3Location withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public SourceS3Location withKey(String key) {
        this.setKey(key);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public SourceS3Location withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public SourceS3Location withRegion(S3BucketRegion region) {
        this.region = region.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceS3Location)) {
            return false;
        }
        SourceS3Location other = (SourceS3Location)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        return other.getRegion() == null || other.getRegion().equals(this.getRegion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        return hashCode;
    }

    public SourceS3Location clone() {
        try {
            return (SourceS3Location)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceS3LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

