/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appflow.model.OAuthProperties;
import java.util.List;

@SdkInternalApi
public class OAuthPropertiesMarshaller {
    private static final MarshallingInfo<String> TOKENURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenUrl").build();
    private static final MarshallingInfo<String> AUTHCODEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authCodeUrl").build();
    private static final MarshallingInfo<List> OAUTHSCOPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oAuthScopes").build();
    private static final OAuthPropertiesMarshaller instance = new OAuthPropertiesMarshaller();

    public static OAuthPropertiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(OAuthProperties oAuthProperties, ProtocolMarshaller protocolMarshaller) {
        if (oAuthProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)oAuthProperties.getTokenUrl(), TOKENURL_BINDING);
            protocolMarshaller.marshall((Object)oAuthProperties.getAuthCodeUrl(), AUTHCODEURL_BINDING);
            protocolMarshaller.marshall(oAuthProperties.getOAuthScopes(), OAUTHSCOPES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

