/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appflow.model.OAuth2Defaults;
import java.util.List;

@SdkInternalApi
public class OAuth2DefaultsMarshaller {
    private static final MarshallingInfo<List> OAUTHSCOPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oauthScopes").build();
    private static final MarshallingInfo<List> TOKENURLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tokenUrls").build();
    private static final MarshallingInfo<List> AUTHCODEURLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authCodeUrls").build();
    private static final MarshallingInfo<List> OAUTH2GRANTTYPESSUPPORTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oauth2GrantTypesSupported").build();
    private static final MarshallingInfo<List> OAUTH2CUSTOMPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oauth2CustomProperties").build();
    private static final OAuth2DefaultsMarshaller instance = new OAuth2DefaultsMarshaller();

    public static OAuth2DefaultsMarshaller getInstance() {
        return instance;
    }

    public void marshall(OAuth2Defaults oAuth2Defaults, ProtocolMarshaller protocolMarshaller) {
        if (oAuth2Defaults == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(oAuth2Defaults.getOauthScopes(), OAUTHSCOPES_BINDING);
            protocolMarshaller.marshall(oAuth2Defaults.getTokenUrls(), TOKENURLS_BINDING);
            protocolMarshaller.marshall(oAuth2Defaults.getAuthCodeUrls(), AUTHCODEURLS_BINDING);
            protocolMarshaller.marshall(oAuth2Defaults.getOauth2GrantTypesSupported(), OAUTH2GRANTTYPESSUPPORTED_BINDING);
            protocolMarshaller.marshall(oAuth2Defaults.getOauth2CustomProperties(), OAUTH2CUSTOMPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

