/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutIntegrationResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class PutIntegrationResponseRequestMarshaller
implements Marshaller<Request<PutIntegrationResponseRequest>, PutIntegrationResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<PutIntegrationResponseRequest> marshall(PutIntegrationResponseRequest putIntegrationResponseRequest) {
        if (putIntegrationResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putIntegrationResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putIntegrationResponseRequest.getRestApiId() != null ? StringUtils.fromString((String)putIntegrationResponseRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{resource_id}", putIntegrationResponseRequest.getResourceId() != null ? StringUtils.fromString((String)putIntegrationResponseRequest.getResourceId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{http_method}", putIntegrationResponseRequest.getHttpMethod() != null ? StringUtils.fromString((String)putIntegrationResponseRequest.getHttpMethod()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{status_code}", putIntegrationResponseRequest.getStatusCode() != null ? StringUtils.fromString((String)putIntegrationResponseRequest.getStatusCode()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> responseTemplatesMap;
            Map<String, String> responseParametersMap;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (putIntegrationResponseRequest.getSelectionPattern() != null) {
                jsonGenerator.writeFieldName("selectionPattern").writeValue(putIntegrationResponseRequest.getSelectionPattern());
            }
            if ((responseParametersMap = putIntegrationResponseRequest.getResponseParameters()) != null) {
                jsonGenerator.writeFieldName("responseParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseParametersMapValue.getKey());
                    jsonGenerator.writeValue(responseParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((responseTemplatesMap = putIntegrationResponseRequest.getResponseTemplates()) != null) {
                jsonGenerator.writeFieldName("responseTemplates");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> responseTemplatesMapValue : responseTemplatesMap.entrySet()) {
                    if (responseTemplatesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseTemplatesMapValue.getKey());
                    jsonGenerator.writeValue(responseTemplatesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

