/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateStageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class CreateStageRequestMarshaller
implements Marshaller<Request<CreateStageRequest>, CreateStageRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<CreateStageRequest> marshall(CreateStageRequest createStageRequest) {
        if (createStageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStageRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/stages";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createStageRequest.getRestApiId() != null ? StringUtils.fromString((String)createStageRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> variablesMap;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createStageRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(createStageRequest.getStageName());
            }
            if (createStageRequest.getDeploymentId() != null) {
                jsonGenerator.writeFieldName("deploymentId").writeValue(createStageRequest.getDeploymentId());
            }
            if (createStageRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(createStageRequest.getDescription());
            }
            if (createStageRequest.getCacheClusterEnabled() != null) {
                jsonGenerator.writeFieldName("cacheClusterEnabled").writeValue(createStageRequest.getCacheClusterEnabled().booleanValue());
            }
            if (createStageRequest.getCacheClusterSize() != null) {
                jsonGenerator.writeFieldName("cacheClusterSize").writeValue(createStageRequest.getCacheClusterSize());
            }
            if ((variablesMap = createStageRequest.getVariables()) != null) {
                jsonGenerator.writeFieldName("variables");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> variablesMapValue : variablesMap.entrySet()) {
                    if (variablesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(variablesMapValue.getKey());
                    jsonGenerator.writeValue(variablesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

