/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutMethodResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class PutMethodResponseRequestMarshaller
implements Marshaller<Request<PutMethodResponseRequest>, PutMethodResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<PutMethodResponseRequest> marshall(PutMethodResponseRequest putMethodResponseRequest) {
        if (putMethodResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putMethodResponseRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)putMethodResponseRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", putMethodResponseRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)putMethodResponseRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", putMethodResponseRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)putMethodResponseRequest.getHttpMethod()));
        uriResourcePath = uriResourcePath.replace("{status_code}", putMethodResponseRequest.getStatusCode() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)putMethodResponseRequest.getStatusCode()));
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> responseModelsMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            Map<String, Boolean> responseParametersMap = putMethodResponseRequest.getResponseParameters();
            if (responseParametersMap != null) {
                jsonWriter.key("responseParameters");
                jsonWriter.object();
                for (Map.Entry<String, Boolean> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonWriter.key(responseParametersMapValue.getKey());
                    jsonWriter.value((Object)responseParametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if ((responseModelsMap = putMethodResponseRequest.getResponseModels()) != null) {
                jsonWriter.key("responseModels");
                jsonWriter.object();
                for (Map.Entry<String, String> responseModelsMapValue : responseModelsMap.entrySet()) {
                    if (responseModelsMapValue.getValue() == null) continue;
                    jsonWriter.key(responseModelsMapValue.getKey());
                    jsonWriter.value((Object)responseModelsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

