/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetResourceRequestMarshaller
implements Marshaller<Request<GetResourceRequest>, GetResourceRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetResourceRequest> marshall(GetResourceRequest getResourceRequest) {
        if (getResourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getResourceRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getResourceRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getResourceRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", getResourceRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getResourceRequest.getResourceId()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

