/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateDomainNameRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateDomainNameRequestMarshaller
implements Marshaller<Request<CreateDomainNameRequest>, CreateDomainNameRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<CreateDomainNameRequest> marshall(CreateDomainNameRequest createDomainNameRequest) {
        if (createDomainNameRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDomainNameRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/domainnames";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createDomainNameRequest.getDomainName() != null) {
                jsonWriter.key("domainName").value((Object)createDomainNameRequest.getDomainName());
            }
            if (createDomainNameRequest.getCertificateName() != null) {
                jsonWriter.key("certificateName").value((Object)createDomainNameRequest.getCertificateName());
            }
            if (createDomainNameRequest.getCertificateBody() != null) {
                jsonWriter.key("certificateBody").value((Object)createDomainNameRequest.getCertificateBody());
            }
            if (createDomainNameRequest.getCertificatePrivateKey() != null) {
                jsonWriter.key("certificatePrivateKey").value((Object)createDomainNameRequest.getCertificatePrivateKey());
            }
            if (createDomainNameRequest.getCertificateChain() != null) {
                jsonWriter.key("certificateChain").value((Object)createDomainNameRequest.getCertificateChain());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

