/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.ApiKey;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class ApiKeyJsonMarshaller {
    private static ApiKeyJsonMarshaller instance;

    public void marshall(ApiKey apiKey, JSONWriter jsonWriter) {
        if (apiKey == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> stageKeysList;
            jsonWriter.object();
            if (apiKey.getId() != null) {
                jsonWriter.key("id").value((Object)apiKey.getId());
            }
            if (apiKey.getName() != null) {
                jsonWriter.key("name").value((Object)apiKey.getName());
            }
            if (apiKey.getDescription() != null) {
                jsonWriter.key("description").value((Object)apiKey.getDescription());
            }
            if (apiKey.getEnabled() != null) {
                jsonWriter.key("enabled").value((Object)apiKey.getEnabled());
            }
            if ((stageKeysList = apiKey.getStageKeys()) != null) {
                jsonWriter.key("stageKeys");
                jsonWriter.array();
                for (String stageKeysListValue : stageKeysList) {
                    if (stageKeysListValue == null) continue;
                    jsonWriter.value((Object)stageKeysListValue);
                }
                jsonWriter.endArray();
            }
            if (apiKey.getCreatedDate() != null) {
                jsonWriter.key("createdDate").value(apiKey.getCreatedDate());
            }
            if (apiKey.getLastUpdatedDate() != null) {
                jsonWriter.key("lastUpdatedDate").value(apiKey.getLastUpdatedDate());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ApiKeyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ApiKeyJsonMarshaller();
        }
        return instance;
    }
}

