/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifyuibuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.amplifyuibuilder.model.ComponentVariant;
import java.util.Map;

@SdkInternalApi
public class ComponentVariantMarshaller {
    private static final MarshallingInfo<Map> OVERRIDES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("overrides").build();
    private static final MarshallingInfo<Map> VARIANTVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("variantValues").build();
    private static final ComponentVariantMarshaller instance = new ComponentVariantMarshaller();

    public static ComponentVariantMarshaller getInstance() {
        return instance;
    }

    public void marshall(ComponentVariant componentVariant, ProtocolMarshaller protocolMarshaller) {
        if (componentVariant == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(componentVariant.getOverrides(), OVERRIDES_BINDING);
            protocolMarshaller.marshall(componentVariant.getVariantValues(), VARIANTVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

