/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifybackend.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.amplifybackend.model.S3BucketInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListS3BucketsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<S3BucketInfo> buckets;
    private String nextToken;

    public List<S3BucketInfo> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Collection<S3BucketInfo> buckets) {
        if (buckets == null) {
            this.buckets = null;
            return;
        }
        this.buckets = new ArrayList<S3BucketInfo>(buckets);
    }

    public ListS3BucketsResult withBuckets(S3BucketInfo ... buckets) {
        if (this.buckets == null) {
            this.setBuckets(new ArrayList<S3BucketInfo>(buckets.length));
        }
        for (S3BucketInfo ele : buckets) {
            this.buckets.add(ele);
        }
        return this;
    }

    public ListS3BucketsResult withBuckets(Collection<S3BucketInfo> buckets) {
        this.setBuckets(buckets);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListS3BucketsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBuckets() != null) {
            sb.append("Buckets: ").append(this.getBuckets()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListS3BucketsResult)) {
            return false;
        }
        ListS3BucketsResult other = (ListS3BucketsResult)obj;
        if (other.getBuckets() == null ^ this.getBuckets() == null) {
            return false;
        }
        if (other.getBuckets() != null && !other.getBuckets().equals(this.getBuckets())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBuckets() == null ? 0 : this.getBuckets().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListS3BucketsResult clone() {
        try {
            return (ListS3BucketsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

