/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.acmpca.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.acmpca.model.CustomExtension;
import com.amazonaws.services.acmpca.model.ExtendedKeyUsage;
import com.amazonaws.services.acmpca.model.GeneralName;
import com.amazonaws.services.acmpca.model.KeyUsage;
import com.amazonaws.services.acmpca.model.PolicyInformation;
import com.amazonaws.services.acmpca.model.transform.ExtensionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Extensions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<PolicyInformation> certificatePolicies;
    private List<ExtendedKeyUsage> extendedKeyUsage;
    private KeyUsage keyUsage;
    private List<GeneralName> subjectAlternativeNames;
    private List<CustomExtension> customExtensions;

    public List<PolicyInformation> getCertificatePolicies() {
        return this.certificatePolicies;
    }

    public void setCertificatePolicies(Collection<PolicyInformation> certificatePolicies) {
        if (certificatePolicies == null) {
            this.certificatePolicies = null;
            return;
        }
        this.certificatePolicies = new ArrayList<PolicyInformation>(certificatePolicies);
    }

    public Extensions withCertificatePolicies(PolicyInformation ... certificatePolicies) {
        if (this.certificatePolicies == null) {
            this.setCertificatePolicies(new ArrayList<PolicyInformation>(certificatePolicies.length));
        }
        for (PolicyInformation ele : certificatePolicies) {
            this.certificatePolicies.add(ele);
        }
        return this;
    }

    public Extensions withCertificatePolicies(Collection<PolicyInformation> certificatePolicies) {
        this.setCertificatePolicies(certificatePolicies);
        return this;
    }

    public List<ExtendedKeyUsage> getExtendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public void setExtendedKeyUsage(Collection<ExtendedKeyUsage> extendedKeyUsage) {
        if (extendedKeyUsage == null) {
            this.extendedKeyUsage = null;
            return;
        }
        this.extendedKeyUsage = new ArrayList<ExtendedKeyUsage>(extendedKeyUsage);
    }

    public Extensions withExtendedKeyUsage(ExtendedKeyUsage ... extendedKeyUsage) {
        if (this.extendedKeyUsage == null) {
            this.setExtendedKeyUsage(new ArrayList<ExtendedKeyUsage>(extendedKeyUsage.length));
        }
        for (ExtendedKeyUsage ele : extendedKeyUsage) {
            this.extendedKeyUsage.add(ele);
        }
        return this;
    }

    public Extensions withExtendedKeyUsage(Collection<ExtendedKeyUsage> extendedKeyUsage) {
        this.setExtendedKeyUsage(extendedKeyUsage);
        return this;
    }

    public void setKeyUsage(KeyUsage keyUsage) {
        this.keyUsage = keyUsage;
    }

    public KeyUsage getKeyUsage() {
        return this.keyUsage;
    }

    public Extensions withKeyUsage(KeyUsage keyUsage) {
        this.setKeyUsage(keyUsage);
        return this;
    }

    public List<GeneralName> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public void setSubjectAlternativeNames(Collection<GeneralName> subjectAlternativeNames) {
        if (subjectAlternativeNames == null) {
            this.subjectAlternativeNames = null;
            return;
        }
        this.subjectAlternativeNames = new ArrayList<GeneralName>(subjectAlternativeNames);
    }

    public Extensions withSubjectAlternativeNames(GeneralName ... subjectAlternativeNames) {
        if (this.subjectAlternativeNames == null) {
            this.setSubjectAlternativeNames(new ArrayList<GeneralName>(subjectAlternativeNames.length));
        }
        for (GeneralName ele : subjectAlternativeNames) {
            this.subjectAlternativeNames.add(ele);
        }
        return this;
    }

    public Extensions withSubjectAlternativeNames(Collection<GeneralName> subjectAlternativeNames) {
        this.setSubjectAlternativeNames(subjectAlternativeNames);
        return this;
    }

    public List<CustomExtension> getCustomExtensions() {
        return this.customExtensions;
    }

    public void setCustomExtensions(Collection<CustomExtension> customExtensions) {
        if (customExtensions == null) {
            this.customExtensions = null;
            return;
        }
        this.customExtensions = new ArrayList<CustomExtension>(customExtensions);
    }

    public Extensions withCustomExtensions(CustomExtension ... customExtensions) {
        if (this.customExtensions == null) {
            this.setCustomExtensions(new ArrayList<CustomExtension>(customExtensions.length));
        }
        for (CustomExtension ele : customExtensions) {
            this.customExtensions.add(ele);
        }
        return this;
    }

    public Extensions withCustomExtensions(Collection<CustomExtension> customExtensions) {
        this.setCustomExtensions(customExtensions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificatePolicies() != null) {
            sb.append("CertificatePolicies: ").append(this.getCertificatePolicies()).append(",");
        }
        if (this.getExtendedKeyUsage() != null) {
            sb.append("ExtendedKeyUsage: ").append(this.getExtendedKeyUsage()).append(",");
        }
        if (this.getKeyUsage() != null) {
            sb.append("KeyUsage: ").append(this.getKeyUsage()).append(",");
        }
        if (this.getSubjectAlternativeNames() != null) {
            sb.append("SubjectAlternativeNames: ").append(this.getSubjectAlternativeNames()).append(",");
        }
        if (this.getCustomExtensions() != null) {
            sb.append("CustomExtensions: ").append(this.getCustomExtensions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Extensions)) {
            return false;
        }
        Extensions other = (Extensions)obj;
        if (other.getCertificatePolicies() == null ^ this.getCertificatePolicies() == null) {
            return false;
        }
        if (other.getCertificatePolicies() != null && !other.getCertificatePolicies().equals(this.getCertificatePolicies())) {
            return false;
        }
        if (other.getExtendedKeyUsage() == null ^ this.getExtendedKeyUsage() == null) {
            return false;
        }
        if (other.getExtendedKeyUsage() != null && !other.getExtendedKeyUsage().equals(this.getExtendedKeyUsage())) {
            return false;
        }
        if (other.getKeyUsage() == null ^ this.getKeyUsage() == null) {
            return false;
        }
        if (other.getKeyUsage() != null && !other.getKeyUsage().equals(this.getKeyUsage())) {
            return false;
        }
        if (other.getSubjectAlternativeNames() == null ^ this.getSubjectAlternativeNames() == null) {
            return false;
        }
        if (other.getSubjectAlternativeNames() != null && !other.getSubjectAlternativeNames().equals(this.getSubjectAlternativeNames())) {
            return false;
        }
        if (other.getCustomExtensions() == null ^ this.getCustomExtensions() == null) {
            return false;
        }
        return other.getCustomExtensions() == null || other.getCustomExtensions().equals(this.getCustomExtensions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificatePolicies() == null ? 0 : this.getCertificatePolicies().hashCode());
        hashCode = 31 * hashCode + (this.getExtendedKeyUsage() == null ? 0 : this.getExtendedKeyUsage().hashCode());
        hashCode = 31 * hashCode + (this.getKeyUsage() == null ? 0 : this.getKeyUsage().hashCode());
        hashCode = 31 * hashCode + (this.getSubjectAlternativeNames() == null ? 0 : this.getSubjectAlternativeNames().hashCode());
        hashCode = 31 * hashCode + (this.getCustomExtensions() == null ? 0 : this.getCustomExtensions().hashCode());
        return hashCode;
    }

    public Extensions clone() {
        try {
            return (Extensions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExtensionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

