/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.certificatemanager.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddTagsToCertificateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String certificateArn;
    private List<Tag> tags;

    public void setCertificateArn(String certificateArn) {
        this.certificateArn = certificateArn;
    }

    public String getCertificateArn() {
        return this.certificateArn;
    }

    public AddTagsToCertificateRequest withCertificateArn(String certificateArn) {
        this.setCertificateArn(certificateArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public AddTagsToCertificateRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public AddTagsToCertificateRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificateArn() != null) {
            sb.append("CertificateArn: " + this.getCertificateArn() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToCertificateRequest)) {
            return false;
        }
        AddTagsToCertificateRequest other = (AddTagsToCertificateRequest)obj;
        if (other.getCertificateArn() == null ^ this.getCertificateArn() == null) {
            return false;
        }
        if (other.getCertificateArn() != null && !other.getCertificateArn().equals(this.getCertificateArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificateArn() == null ? 0 : this.getCertificateArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public AddTagsToCertificateRequest clone() {
        return (AddTagsToCertificateRequest)super.clone();
    }
}

