/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisConsumerStates;

public enum ShutdownReason {
    ZOMBIE(3, KinesisConsumerStates.ShardConsumerState.SHUTTING_DOWN.getConsumerState()),
    TERMINATE(2, KinesisConsumerStates.ShardConsumerState.SHUTTING_DOWN.getConsumerState()),
    REQUESTED(1, KinesisConsumerStates.ShardConsumerState.SHUTDOWN_REQUESTED.getConsumerState());

    private final int rank;
    private final KinesisConsumerStates.ConsumerState shutdownState;

    private ShutdownReason(int rank, KinesisConsumerStates.ConsumerState shutdownState) {
        this.rank = rank;
        this.shutdownState = shutdownState;
    }

    public boolean canTransitionTo(ShutdownReason reason) {
        if (reason == null) {
            return false;
        }
        return reason.rank > this.rank;
    }

    public KinesisConsumerStates.ConsumerState getShutdownState() {
        return this.shutdownState;
    }
}

