/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.support.conv;

import com.amazon.support.conv.ConversionResult;
import com.amazon.support.conv.ConverterConstants;
import com.amazon.support.conv.DateTimeConverter;
import com.amazon.support.conv.ExactNumConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.UUID;
import java.util.regex.Matcher;

public class CharConverter {
    private CharConverter() {
    }

    public static boolean toBoolean(String string, ConversionResult conversionResult) {
        if ("true".equalsIgnoreCase(string = string.trim())) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return true;
        }
        if ("false".equalsIgnoreCase(string)) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return false;
        }
        conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
        return false;
    }

    public static BigInteger toBigInt(String string, ConversionResult conversionResult, boolean bl) {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        if (bl) {
            bigInteger = ConverterConstants.SIGNED_BIGINT_MAX;
            bigInteger2 = ConverterConstants.SIGNED_BIGINT_MIN;
        } else {
            bigInteger = ConverterConstants.UNSIGNED_BIGINT_MAX;
            bigInteger2 = BigInteger.ZERO;
        }
        return CharConverter.convertInteger(string, conversionResult, bigInteger2, bigInteger);
    }

    public static boolean toBit(String string, ConversionResult conversionResult) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if ((string = string.trim()).length() == 1) {
            if (string.charAt(0) == '0') {
                conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
                return false;
            }
            if (string.charAt(0) == '1') {
                conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
                return true;
            }
        }
        if (null == (bigInteger3 = CharConverter.convertInteger(string, conversionResult, bigInteger2 = BigInteger.ZERO, bigInteger = BigInteger.ONE))) {
            assert (ConversionResult.TypeConversionState.SUCCESS != conversionResult.getState());
            return false;
        }
        return bigInteger3.compareTo(BigInteger.ONE) == 0;
    }

    public static String toChar(String string, long l, ConversionResult conversionResult) {
        String string2 = string;
        if ((long)string2.length() <= l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            string2 = string2.substring(0, (int)l);
        }
        return string2;
    }

    public static Date toDate(String string, ConversionResult conversionResult, GregorianCalendar gregorianCalendar) {
        if (null == gregorianCalendar) {
            gregorianCalendar = new GregorianCalendar();
        }
        gregorianCalendar.clear();
        Matcher matcher = ConverterConstants.TIMESTAMP_PATTERN.matcher(string.trim());
        int[] nArray = CharConverter.parseTimestamp(gregorianCalendar, matcher);
        if (nArray == null) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        if (0 > nArray[0]) {
            gregorianCalendar.set(0, 0);
            nArray[0] = nArray[0] * -1;
        }
        gregorianCalendar.set(nArray[0], nArray[1] - 1, nArray[2], 0, 0, 0);
        gregorianCalendar.set(14, 0);
        if (nArray[3] != 0 || nArray[4] != 0 || nArray[5] != 0 || nArray[6] != 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.DATETIME_OVERFLOW);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return new Date(gregorianCalendar.getTimeInMillis());
    }

    public static double toDouble(String string, ConversionResult conversionResult) {
        if ((string = string.trim()).equalsIgnoreCase("NaN")) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Double.NaN;
        }
        if (string.equalsIgnoreCase("INFINITY")) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Double.POSITIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("-INFINITY")) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Double.NEGATIVE_INFINITY;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return d;
        }
        if (d == Double.POSITIVE_INFINITY) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else if (d == Double.NEGATIVE_INFINITY) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return d;
    }

    public static BigDecimal toExactNum(String string, ConversionResult conversionResult, short s, short s2) {
        BigDecimal bigDecimal;
        if (CharConverter.isNanStr(string = string.trim())) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        if (CharConverter.isPosInfStr(string)) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (CharConverter.isNegInfStr(string)) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        return ExactNumConverter.setPrecScale(bigDecimal, s, s2, conversionResult);
    }

    public static double toFloat(String string, ConversionResult conversionResult) {
        return CharConverter.toDouble(string, conversionResult);
    }

    public static UUID toGUID(String string, ConversionResult conversionResult) {
        string = string.trim();
        byte[] byArray = new byte[16];
        if (!(36 == string.length() && CharConverter.convertHex(string.substring(0, 8), byArray, 0) && '-' == string.charAt(8) && CharConverter.convertHex(string.substring(9, 13), byArray, 4) && '-' == string.charAt(13) && CharConverter.convertHex(string.substring(14, 18), byArray, 6) && '-' == string.charAt(18) && CharConverter.convertHex(string.substring(19, 23), byArray, 8) && '-' == string.charAt(23) && CharConverter.convertHex(string.substring(24), byArray, 10))) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(byArray[i] & 0xFF);
        }
        long l2 = 0L;
        for (int i = 8; i < 16; ++i) {
            l2 = l2 << 8 | (long)(byArray[i] & 0xFF);
        }
        conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        return new UUID(l, l2);
    }

    public static long toInteger(String string, ConversionResult conversionResult, boolean bl) {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        if (bl) {
            bigInteger = ConverterConstants.SIGNED_INT_MAX;
            bigInteger2 = ConverterConstants.SIGNED_INT_MIN;
        } else {
            bigInteger = ConverterConstants.UNSIGNED_INT_MAX;
            bigInteger2 = BigInteger.ZERO;
        }
        BigInteger bigInteger3 = CharConverter.convertInteger(string, conversionResult, bigInteger2, bigInteger);
        if (bigInteger3 == null) {
            assert (ConversionResult.TypeConversionState.SUCCESS != conversionResult.getState());
            return -1L;
        }
        return bigInteger3.longValue();
    }

    public static float toReal(String string, ConversionResult conversionResult) {
        if ((string = string.trim()).equalsIgnoreCase("NaN")) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Float.NaN;
        }
        if (string.equalsIgnoreCase("INFINITY")) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Float.POSITIVE_INFINITY;
        }
        if (string.equalsIgnoreCase("-INFINITY")) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return Float.NEGATIVE_INFINITY;
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return f;
        }
        if (f == Float.POSITIVE_INFINITY) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
        } else if (f == Float.NEGATIVE_INFINITY) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return f;
    }

    public static int toSmallint(String string, ConversionResult conversionResult, boolean bl) {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        if (bl) {
            bigInteger = ConverterConstants.SIGNED_SMALLINT_MAX;
            bigInteger2 = ConverterConstants.SIGNED_SMALLINT_MIN;
        } else {
            bigInteger = ConverterConstants.UNSIGNED_SMALLINT_MAX;
            bigInteger2 = BigInteger.ZERO;
        }
        BigInteger bigInteger3 = CharConverter.convertInteger(string, conversionResult, bigInteger2, bigInteger);
        if (bigInteger3 == null) {
            assert (ConversionResult.TypeConversionState.SUCCESS != conversionResult.getState());
            return -1;
        }
        return bigInteger3.intValue();
    }

    public static Time toTime(String string, ConversionResult conversionResult, short s, GregorianCalendar gregorianCalendar) {
        int[] nArray;
        if (s < 0 || s > 9) {
            throw new IllegalArgumentException("Invalid precision");
        }
        if (null == gregorianCalendar) {
            gregorianCalendar = new GregorianCalendar();
        }
        if ((nArray = CharConverter.parseTime(string, gregorianCalendar)) == null) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        gregorianCalendar.clear();
        gregorianCalendar.set(1970, 0, 1, nArray[3], nArray[4], nArray[5]);
        int n = DateTimeConverter.calculateFractionalSeconds(nArray[6], Math.min(s, 3));
        gregorianCalendar.set(14, n / 1000000);
        Time time = new Time(gregorianCalendar.getTimeInMillis());
        if (n != nArray[6]) {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        if (nArray[0] != 0 || nArray[1] != 0 || nArray[2] != 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.DATETIME_OVERFLOW);
        }
        return time;
    }

    public static Timestamp toTimestamp(String string, ConversionResult conversionResult, short s, GregorianCalendar gregorianCalendar) {
        Matcher matcher = ConverterConstants.TIMESTAMP_PATTERN.matcher(string.trim());
        if (matcher.matches()) {
            if (s < 0 || s > 9) {
                throw new IllegalArgumentException("Invalid precision");
            }
            if (null == gregorianCalendar) {
                gregorianCalendar = new GregorianCalendar();
            }
            return CharConverter.doTsStrToTimestamp(conversionResult, s, gregorianCalendar, matcher);
        }
        return CharConverter.timeStrToTimestamp(string, conversionResult, s, gregorianCalendar);
    }

    public static short toTinyint(String string, ConversionResult conversionResult, boolean bl) {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        if (bl) {
            bigInteger = ConverterConstants.SIGNED_TINYINT_MAX;
            bigInteger2 = ConverterConstants.SIGNED_TINYINT_MIN;
        } else {
            bigInteger = ConverterConstants.UNSIGNED_TINYINT_MAX;
            bigInteger2 = BigInteger.ZERO;
        }
        BigInteger bigInteger3 = CharConverter.convertInteger(string, conversionResult, bigInteger2, bigInteger);
        if (bigInteger3 == null) {
            return -1;
        }
        return bigInteger3.shortValue();
    }

    public static Timestamp tsStrToTimestamp(String string, ConversionResult conversionResult, short s, GregorianCalendar gregorianCalendar) {
        if (s < 0 || s > 9) {
            throw new IllegalArgumentException("Invalid precision");
        }
        if (null == gregorianCalendar) {
            gregorianCalendar = new GregorianCalendar();
        }
        Matcher matcher = ConverterConstants.TIMESTAMP_PATTERN.matcher(string.trim());
        return CharConverter.doTsStrToTimestamp(conversionResult, s, gregorianCalendar, matcher);
    }

    public static Timestamp timeStrToTimestamp(String string, ConversionResult conversionResult, short s, GregorianCalendar gregorianCalendar) {
        int[] nArray;
        if (s < 0 || s > 9) {
            throw new IllegalArgumentException("Invalid precision");
        }
        if (null == gregorianCalendar) {
            gregorianCalendar = new GregorianCalendar();
        }
        if ((nArray = CharConverter.parseTime(string, gregorianCalendar)) == null) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        gregorianCalendar.clear();
        gregorianCalendar.set(1970, 0, 1, nArray[3], nArray[4], nArray[5]);
        int n = DateTimeConverter.calculateFractionalSeconds(nArray[6], s);
        Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
        timestamp.setNanos(n);
        conversionResult.setState(n != nArray[6] ? ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN : ConversionResult.TypeConversionState.SUCCESS);
        return timestamp;
    }

    private static boolean convertHex(CharSequence charSequence, byte[] byArray, int n) {
        int n2 = charSequence.length();
        if (0 != n2 % 2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Character.digit(charSequence.charAt(n3++), 16);
            int n5 = Character.digit(charSequence.charAt(n3++), 16);
            if (0 > n4 || 0 > n5) {
                return false;
            }
            byArray[n++] = (byte)(n4 << 4 | n5);
        }
        return true;
    }

    private static BigInteger convertInteger(String string, ConversionResult conversionResult, BigInteger bigInteger, BigInteger bigInteger2) {
        if (CharConverter.isNanStr(string = string.trim())) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        if (CharConverter.isPosInfStr(string)) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (CharConverter.isNegInfStr(string)) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        BigInteger bigInteger3 = bigDecimal.toBigInteger();
        if (bigInteger3.compareTo(bigInteger) < 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        if (bigInteger3.compareTo(bigInteger2) > 0) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (bigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0) {
            if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            }
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return bigInteger3;
    }

    private static Timestamp doTsStrToTimestamp(ConversionResult conversionResult, short s, GregorianCalendar gregorianCalendar, Matcher matcher) {
        int[] nArray = CharConverter.parseTimestamp(gregorianCalendar, matcher);
        if (nArray == null) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST);
            return null;
        }
        gregorianCalendar.clear();
        gregorianCalendar.set(0, nArray[0] < 0 ? 0 : 1);
        gregorianCalendar.set(Math.abs(nArray[0]), nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
        Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
        int n = DateTimeConverter.calculateFractionalSeconds(nArray[6], s);
        timestamp.setNanos(n);
        if (n != nArray[6]) {
            conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        }
        return timestamp;
    }

    private static int[] parseTimestamp(GregorianCalendar gregorianCalendar, Matcher matcher) {
        if (!matcher.matches()) {
            return null;
        }
        int[] nArray = new int[7];
        for (int i = 0; i < 6; ++i) {
            String string = matcher.group(i + 1);
            nArray[i] = string == null ? 0 : Integer.parseInt(string);
        }
        if (!CharConverter.checkGregorianDate(nArray[0], nArray[1], nArray[2], gregorianCalendar) || !CharConverter.checkTime(nArray[3], nArray[4], nArray[5])) {
            return null;
        }
        String string = matcher.group(7);
        if (string == null) {
            nArray[6] = 0;
            return nArray;
        }
        nArray[6] = Integer.parseInt(string) * ConverterConstants.FRACTIONAL_MOD[string.length()];
        return nArray;
    }

    private static int[] parseTime(String string, GregorianCalendar gregorianCalendar) {
        Matcher matcher = ConverterConstants.TIME_PATTERN.matcher(string.trim());
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        int[] nArray = new int[7];
        if (string2 != null) {
            nArray[0] = Integer.parseInt(string2);
            nArray[1] = Integer.parseInt(string3);
            nArray[2] = Integer.parseInt(string4);
            if (!CharConverter.checkGregorianDate(nArray[0], nArray[1], nArray[2], gregorianCalendar)) {
                return null;
            }
        } else {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
        }
        nArray[3] = Integer.parseInt(matcher.group(4));
        nArray[4] = Integer.parseInt(matcher.group(5));
        nArray[5] = Integer.parseInt(matcher.group(6));
        if (!CharConverter.checkTime(nArray[3], nArray[4], nArray[5])) {
            return null;
        }
        String string5 = matcher.group(7);
        if (string5 == null) {
            nArray[6] = 0;
            return nArray;
        }
        nArray[6] = Integer.parseInt(string5) * ConverterConstants.FRACTIONAL_MOD[string5.length()];
        return nArray;
    }

    private static boolean checkGregorianDate(int n, int n2, int n3, GregorianCalendar gregorianCalendar) {
        if (n == 0) {
            return false;
        }
        gregorianCalendar.clear();
        gregorianCalendar.set(0, n < 0 ? 0 : 1);
        gregorianCalendar.set(Math.abs(n), --n2, n3);
        return gregorianCalendar.get(1) == Math.abs(n) && gregorianCalendar.get(2) == n2 && gregorianCalendar.get(5) == n3;
    }

    private static boolean checkTime(int n, int n2, int n3) {
        if (n < 0 || n > 23) {
            return false;
        }
        if (n2 < 0 || n2 > 59) {
            return false;
        }
        return n3 >= 0 && n3 <= 61;
    }

    private static boolean isPosInfStr(String string) {
        return string.equalsIgnoreCase("INFINITY");
    }

    private static boolean isNegInfStr(String string) {
        return string.equalsIgnoreCase("-INFINITY");
    }

    private static boolean isNanStr(String string) {
        return string.equalsIgnoreCase("NaN");
    }
}

