/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.support;

import com.amazon.support.IMessageSource;
import com.amazon.support.IWarningListener;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.DiagState;
import com.amazon.support.exceptions.ErrorException;
import java.util.Locale;

public class Warning {
    private int m_nativeErrorCode = -1;
    private WarningCode m_warningCode;
    private String m_customState;
    private String m_msgKey;
    private String[] m_msgParams = null;
    private String m_message;
    private int m_componentId;
    private long m_rowNumber;
    private int m_columnNumber;
    private boolean m_hasPreformattedMessage = false;

    public Warning(WarningCode warningCode, String string, int n) {
        this(warningCode, string, n, -1L, -1);
    }

    public Warning(WarningCode warningCode, String string, int n, long l, int n2) {
        this.m_warningCode = warningCode;
        this.m_message = null == string ? "" : string;
        this.m_nativeErrorCode = n;
        this.m_rowNumber = l;
        this.m_columnNumber = n2;
    }

    public Warning(WarningCode warningCode, int n, String string) {
        this(warningCode, n, string, -1L, -1);
    }

    public Warning(WarningCode warningCode, int n, String string, String[] stringArray) {
        this(warningCode, n, string, stringArray, -1L, -1);
    }

    public Warning(WarningCode warningCode, int n, String string, long l, int n2) {
        this(warningCode, n, string, null, l, n2);
    }

    public Warning(WarningCode warningCode, int n, String string, String[] stringArray, long l, int n2) {
        this.m_warningCode = warningCode;
        this.m_customState = null;
        this.m_componentId = n;
        this.m_msgKey = string;
        this.m_msgParams = stringArray;
        this.m_rowNumber = l;
        this.m_columnNumber = n2;
    }

    public Warning(WarningCode warningCode, String string) {
        this(warningCode, string, -1, -1);
    }

    public Warning(WarningCode warningCode, String string, int n, int n2) {
        this.m_warningCode = warningCode;
        this.m_message = null == string ? "" : string;
        this.m_hasPreformattedMessage = true;
        this.m_rowNumber = n;
        this.m_columnNumber = n2;
    }

    public Warning(String string, String string2) {
        this(string, string2, -1, -1);
    }

    public Warning(String string, String string2, int n, int n2) {
        this.m_warningCode = WarningCode.GENERAL_WARNING;
        this.m_customState = string;
        this.m_message = null == string2 ? "" : string2;
        this.m_hasPreformattedMessage = true;
        this.m_rowNumber = n;
        this.m_columnNumber = n2;
    }

    public Warning(String string, int n, String string2, int n2, int n3) {
        this(string, n, string2, null, n2, n3);
    }

    public Warning(String string, int n, String string2, String[] stringArray, int n2, int n3) {
        this.m_warningCode = WarningCode.GENERAL_WARNING;
        this.m_customState = string;
        this.m_componentId = n;
        this.m_msgKey = string2;
        this.m_msgParams = stringArray;
        this.m_rowNumber = n2;
        this.m_columnNumber = n3;
    }

    public Warning(String string, String string2, int n) {
        this(string, string2, n, -1, -1);
    }

    public Warning(String string, String string2, int n, int n2, int n3) {
        this.m_warningCode = WarningCode.GENERAL_WARNING;
        this.m_customState = string;
        this.m_message = null == string2 ? "" : string2;
        this.m_hasPreformattedMessage = true;
        this.m_nativeErrorCode = n;
        this.m_rowNumber = n2;
        this.m_columnNumber = n3;
    }

    public Warning(String string, String string2, int n, long l, int n2, DiagState diagState) {
        this.m_warningCode = WarningCode.getWarningCode(diagState);
        this.m_customState = string;
        this.m_message = null == string2 ? "" : string2;
        this.m_hasPreformattedMessage = true;
        this.m_nativeErrorCode = n;
        this.m_rowNumber = l;
        this.m_columnNumber = n2;
    }

    public static Warning getWarningFromException(ErrorException errorException, IMessageSource iMessageSource, Locale locale) {
        return new Warning(errorException.getDiagState().getSqlState(), errorException.getMessage(), errorException.getNativeErrorCode(iMessageSource, locale), errorException.getRowNumber(), errorException.getColumnNumber(), errorException.getDiagState());
    }

    public static void postErrorExceptionAsWarning(ErrorException errorException, IWarningListener iWarningListener) {
        iWarningListener.postWarning(Warning.getWarningFromException(errorException, iWarningListener.getMessageSource(), iWarningListener.getLocale()));
    }

    public int getNativeErrorCode() {
        return this.m_nativeErrorCode;
    }

    public int getColumnNumber() {
        return this.m_columnNumber;
    }

    public int getComponentId() {
        return this.m_componentId;
    }

    public String getCustomState() {
        return this.m_customState;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getMessageKey() {
        return this.m_msgKey;
    }

    public String[] getMessageParams() {
        return this.m_msgParams;
    }

    public long getRowNumber() {
        return this.m_rowNumber;
    }

    public WarningCode getWarningCode() {
        return this.m_warningCode;
    }

    public boolean hasCustomState() {
        return null != this.m_customState;
    }

    public boolean hasMessageParams() {
        return null != this.m_msgParams;
    }

    public boolean hasPreformattedMessage() {
        return this.m_hasPreformattedMessage;
    }

    public void setLocalizedWarningMessage(IMessageSource iMessageSource, Locale locale) {
        if (this.m_hasPreformattedMessage || null == this.m_msgKey) {
            return;
        }
        this.m_message = this.hasMessageParams() ? iMessageSource.loadMessage(locale, this.m_componentId, this.m_msgKey, this.m_msgParams) : iMessageSource.loadMessage(locale, this.m_componentId, this.m_msgKey);
    }
}

