/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazon.support.LogUtilities;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class PingCredentialsProvider
extends SamlCredentialsProvider {
    private static final Pattern SAML_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");
    private static final String KEY_PARTNER_SPID = "partner_spid";
    protected String m_partnerSpId;

    @Override
    public void addParameter(String string, String string2) {
        super.addParameter(string, string2);
        if (KEY_PARTNER_SPID.equalsIgnoreCase(string)) {
            this.m_partnerSpId = string2;
        }
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        this.checkRequiredParameters();
        this.m_partnerSpId = StringUtils.isNullOrEmpty((String)this.m_partnerSpId) ? "urn%3Aamazon%3Awebservices" : URLEncoder.encode(this.m_partnerSpId, "UTF-8");
        String string = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/idp/startSSO.ping?PartnerSpId=" + this.m_partnerSpId;
        CloseableHttpClient closeableHttpClient = null;
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(5);
        try {
            String string2;
            Object object;
            String string3;
            String string42;
            closeableHttpClient = this.getHttpClient();
            HttpGet httpGet = new HttpGet(string);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpGet);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            String string5 = EntityUtils.toString((HttpEntity)httpEntity);
            BasicNameValuePair basicNameValuePair = null;
            BasicNameValuePair basicNameValuePair2 = null;
            String string6 = null;
            for (String string42 : this.getInputTagsfromHTML(string5)) {
                string3 = this.getValueByKey(string42, "name");
                object = this.getValueByKey(string42, "id");
                string2 = this.getValueByKey(string42, "value");
                LogUtilities.logDebug("input tags[ name: " + string3 + " , id: " + (String)object + " , value: " + string2 + " ]", this.m_log);
                if (basicNameValuePair == null && "username".equals(object) && this.isText(string42)) {
                    basicNameValuePair = new BasicNameValuePair(string3, this.m_userName);
                    continue;
                }
                if (("pf.pass".equals(string3) || string3.contains("pass")) && this.isPassword(string42)) {
                    if (basicNameValuePair2 != null) {
                        LogUtilities.logDebug(String.format("pass field: %s has conflict with field: %s", string6, string42), this.m_log);
                        LogUtilities.logTrace(string5, this.m_log);
                        throw new IOException("Duplicate password fields on login page.");
                    }
                    string6 = string42;
                    basicNameValuePair2 = new BasicNameValuePair(string3, this.m_password);
                    continue;
                }
                if (StringUtils.isNullOrEmpty((String)string3)) continue;
                arrayList.add(new BasicNameValuePair(string3, string2));
            }
            if (basicNameValuePair == null) {
                for (String string42 : this.getInputTagsfromHTML(string5)) {
                    string3 = this.getValueByKey(string42, "name");
                    if (!"email".equals(string3) && !string3.contains("user") && !string3.contains("email") || !this.isText(string42)) continue;
                    basicNameValuePair = new BasicNameValuePair(string3, this.m_userName);
                }
            }
            if (basicNameValuePair == null || basicNameValuePair2 == null) {
                LogUtilities.logTrace(string5, this.m_log);
                throw new IOException("Failed to parse login form.");
            }
            arrayList.add(basicNameValuePair);
            arrayList.add(basicNameValuePair2);
            String string7 = this.getFormAction(string5);
            LogUtilities.logDebug("action from body: " + (String)string7, this.m_log);
            if (!StringUtils.isNullOrEmpty((String)string7) && string7.startsWith("/")) {
                string = "https://" + this.m_idpHost + ':' + this.m_idpPort + (String)string7;
            }
            string42 = new HttpPost(string);
            LogUtilities.logDebug("send parameters: " + ((Object)arrayList).toString() + "\n    to uri:" + string, this.m_log);
            string42.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)string42);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            string3 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
            object = SAML_PATTERN.matcher(string3);
            if (!((Matcher)object).find()) {
                throw new IOException("Failed to retrieve SAMLAssertion.");
            }
            string2 = ((Matcher)object).group(1);
            return string2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", (Throwable)generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly((Closeable)closeableHttpClient, null);
        }
    }
}

