/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.antlr4.sql.escaper.AbstractStoredProcedureHelper;
import com.amazon.antlr4.sql.escaper.NoOpJDBCReplacer;
import com.amazon.antlr4.sql.escaper.ProcessedStatement;
import com.amazon.dsi.dataengine.impl.DSIDataEngine;
import com.amazon.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.amazon.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.dsi.dataengine.utilities.OrderType;
import com.amazon.dsi.exceptions.ParsingException;
import com.amazon.jdbc.utils.DataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGBatchQueryExecutor;
import com.amazon.redshift.dataengine.PGCatalogQueryBuilder;
import com.amazon.redshift.dataengine.PGEscaper;
import com.amazon.redshift.dataengine.PGQueryExecutor;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.dataengine.metadata.PGJDBCTypeInfoMetadataSource;
import com.amazon.redshift.dataengine.metadata.PGMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGTablePrivilegesMetadatSourceFromQuery;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PGDataEngine
extends DSIDataEngine {
    private static final String STMT_NAME_PREFIX = "PGJDBCStmt-";
    private PGClient m_client;
    private PGJDBCStatement m_statement;
    private ILogger m_log;
    private boolean m_isDatashare;
    private boolean m_isDirectExecution;
    private int m_socketTimeoutMS;
    private PGJDBCSettings m_settings;
    private AbstractStoredProcedureHelper m_spHelper;
    private Map<String, PGMessagingContext> m_contextMap = new HashMap<String, PGMessagingContext>();

    public PGDataEngine(PGJDBCStatement pGJDBCStatement, PGClient pGClient, PGJDBCSettings pGJDBCSettings, AbstractStoredProcedureHelper abstractStoredProcedureHelper, ILogger iLogger, int n) {
        super(pGJDBCStatement);
        this.m_statement = pGJDBCStatement;
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_settings = pGJDBCSettings;
        this.m_isDirectExecution = false;
        this.m_socketTimeoutMS = n;
        this.m_spHelper = abstractStoredProcedureHelper;
        this.m_isDatashare = pGClient.isDatashareEnabled() && !pGJDBCSettings.m_databaseMetadataCurrentDbOnly;
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, list);
        return new PGBatchQueryExecutor(list, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, this.m_spHelper, true);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        NoOpJDBCReplacer.EscaperResult escaperResult = PGEscaper.apply(string, this.m_statement.isCallableStatement(), this.m_spHelper);
        if (1 == escaperResult.getStatements().size()) {
            ProcessedStatement processedStatement = escaperResult.getStatements().get(0);
            try {
                this.m_statement.sethasReturnQuestionMark(processedStatement.hasReturnParameter());
                return new PGQueryExecutor(processedStatement, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, processedStatement.getParamCount(), this.m_spHelper);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                exceptionInInitializerError.printStackTrace();
                throw exceptionInInitializerError;
            }
            catch (ErrorException errorException) {
                if (this.m_statement.isCallableStatement()) {
                    String[] stringArray = errorException.getMessageParams();
                    ErrorException errorException2 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_CALL_ERROR, stringArray, (Throwable)errorException);
                    throw errorException2;
                }
                throw errorException;
            }
        }
        if (!escaperResult.getContainsCallWithOutput()) {
            return new PGBatchQueryExecutor(string, escaperResult.getStatements(), this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, false);
        }
        ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR, new String[]{"multi query cannot contain a CALL statement with output parameter(s)", string});
        throw errorException;
    }

    @Override
    public void setDirectExecute() {
        this.m_isDirectExecution = true;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        if (MetadataSourceID.PRIMARY_KEYS == metadataSourceID) {
            return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, OrderType.NONE);
        }
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, orderType);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        String string3 = STMT_NAME_PREFIX + this.getCatalogName(metadataSourceID);
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new PGJDBCTypeInfoMetadataSource(this.getLog());
            }
            case TABLETYPE_ONLY: {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("TABLE");
                arrayList.add("VIEW");
                arrayList.add("SEQUENCE");
                arrayList.add("INDEX");
                arrayList.add("SYSTEM TABLE");
                arrayList.add("SYSTEM TOAST TABLE");
                arrayList.add("TEMPORARY TABLE");
                arrayList.add("EXTERNAL TABLE");
                arrayList.add("SYSTEM VIEW");
                arrayList.add("TEMPORARY VIEW");
                arrayList.add("SYSTEM INDEX");
                arrayList.add("SYSTEM TOAST INDEX");
                arrayList.add("TEMPORARY INDEX");
                arrayList.add("TEMPORARY SEQUENCE");
                arrayList.add("TYPE");
                return new DSITableTypeOnlyMetadataSource(this.getLog(), arrayList);
            }
            case TABLES: {
                this.setHasExtSchemaPatternMatch(map);
                return this.runGetTables(metadataSourceID, map);
            }
            case COLUMNS: {
                this.setHasExtSchemaPatternMatch(map);
                return this.runGetColumns(metadataSourceID, map);
            }
            case CATALOG_ONLY: 
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                boolean bl2;
                String string4 = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
                String string5 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                boolean bl3 = !this.isFilterNullOrEmpty(string4);
                boolean bl4 = bl2 = !this.isFilterNullOrEmpty(string5);
                if (this.m_isDatashare && bl3) {
                    string3 = string3 + "Catalog";
                }
                if (bl2) {
                    string3 = string3 + "Schema";
                }
                this.prepareCatalogFunction(metadataSourceID, map, string3);
                return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(string3));
            }
            case FOREIGN_KEYS: {
                return this.runGetForeignKeys(metadataSourceID, map);
            }
            case PRIMARY_KEYS: {
                return this.runGetPrimaryKeys(metadataSourceID, map);
            }
            case TABLE_PRIVILEGES: {
                return this.runGetTablePrivileges(metadataSourceID, map);
            }
            case PROCEDURES: {
                return this.runGetProcedures(metadataSourceID, map);
            }
            case PROCEDURE_COLUMNS: {
                String string6 = ((PGJDBCConnection)this.m_statement.getParentConnection()).getServerVersion();
                int n = Integer.parseInt(string6.split("\\.")[0]);
                int n2 = Integer.parseInt(string6.split("\\.")[1]);
                if (n >= 8 && n2 >= 4) {
                    return this.runGetProcedureColumns(metadataSourceID, map);
                }
                return this.runGetOldProcedureColumns(metadataSourceID, map);
            }
            case FUNCTIONS_JDBC4: {
                return this.runGetFunctionsJDBC4(metadataSourceID, map);
            }
            case FUNCTION_COLUMNS_JDBC4: {
                return this.runGetFunctionColumns(metadataSourceID, map);
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }

    public void setHasExtSchemaPatternMatch(Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        if (null != string && !string.equals("")) {
            if (null == this.m_contextMap.get("checkExternalSchema")) {
                this.m_contextMap.put("checkExternalSchema", this.m_client.prepareStatement("select 1 from svv_external_schemas where schemaname like $1", null, true));
            }
            byte[][] byArray = new byte[1][0];
            byArray[0] = DataTypeUtilities.toUTF8ByteArray(string);
            this.m_client.executePreparedStatement(this.m_contextMap.get("checkExternalSchema"), 0, 0, true, byArray, 0);
            PGResultSet pGResultSet = new PGResultSet(this.m_contextMap.get("checkExternalSchema"), this.m_log);
            pGResultSet.closeCursor();
            this.m_settings.m_hasExtSchemaPatternMatch = pGResultSet.getRowCount() > 0L;
        } else {
            this.m_settings.m_hasExtSchemaPatternMatch = true;
        }
    }

    public IMetadataSource runGetTables(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string4 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        boolean bl3 = !this.isFilterNullOrEmpty(string3);
        boolean bl4 = !this.isFilterNullOrEmpty(string4);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (this.m_settings.m_hasExtSchemaPatternMatch) {
            stringBuilder.append("Ext");
        }
        if (this.m_isDatashare && bl) {
            stringBuilder.append("Catalog");
        }
        if (bl2) {
            stringBuilder.append("Schema");
        }
        if (bl3) {
            stringBuilder.append("Table");
        }
        if (bl4) {
            String[] stringArray = string4.split(",");
            n = stringArray.length;
            stringBuilder.append("TableType");
            stringBuilder.append(n);
        }
        this.prepareCatalogFunction(metadataSourceID, map, stringBuilder.toString());
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
    }

    public IMetadataSource runGetColumns(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        String string4 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        boolean bl3 = !this.isFilterNullOrEmpty(string3);
        boolean bl4 = !this.isFilterNullOrEmpty(string4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (this.m_settings.m_hasExtSchemaPatternMatch) {
            stringBuilder.append("Ext");
        }
        if (this.m_isDatashare && bl) {
            stringBuilder.append("Catalog");
        }
        if (bl2) {
            stringBuilder.append("Schema");
        }
        if (bl3) {
            stringBuilder.append("Table");
        }
        if (bl4) {
            stringBuilder.append("Column");
        }
        this.prepareCatalogFunction(metadataSourceID, map, stringBuilder.toString());
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
    }

    public IMetadataSource runGetForeignKeys(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
        String string4 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        boolean bl3 = !this.isFilterNullOrEmpty(string3);
        boolean bl4 = !this.isFilterNullOrEmpty(string4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (bl) {
            stringBuilder.append("Schema");
        }
        if (bl2) {
            stringBuilder.append("Table");
        }
        if (bl3) {
            stringBuilder.append("FSchema");
        }
        if (bl4) {
            stringBuilder.append("FTable");
        }
        this.prepareCatalogFunction(metadataSourceID, map, stringBuilder.toString());
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
    }

    public IMetadataSource runGetPrimaryKeys(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (bl) {
            stringBuilder.append("Schema");
        }
        if (bl2) {
            stringBuilder.append("Table");
        }
        this.prepareCatalogFunction(metadataSourceID, map, stringBuilder.toString());
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
    }

    public IMetadataSource runGetTablePrivileges(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (bl) {
            stringBuilder.append("Schema");
        }
        if (bl2) {
            stringBuilder.append("Table");
        }
        this.prepareCatalogFunction(metadataSourceID, map, stringBuilder.toString());
        this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
        return new PGTablePrivilegesMetadatSourceFromQuery(this.m_contextMap.get(stringBuilder.toString()), this.m_log);
    }

    public IMetadataSource runGetProcedures(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (bl) {
            stringBuilder.append("Schema");
        }
        if (bl2) {
            stringBuilder.append("Procedure");
        }
        this.prepareCatalogFunction(metadataSourceID, map, stringBuilder.toString());
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
    }

    public IMetadataSource runGetProcedureColumns(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        boolean bl3 = !this.isFilterNullOrEmpty(string3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (bl) {
            stringBuilder.append("Schema");
        }
        if (bl2) {
            stringBuilder.append("Procedure");
        }
        if (bl3) {
            stringBuilder.append("Column");
        }
        this.prepareCatalogFunction(metadataSourceID, map, stringBuilder.toString());
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
    }

    public IMetadataSource runGetOldProcedureColumns(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        boolean bl3 = !this.isFilterNullOrEmpty(string3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append("Old");
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (bl) {
            stringBuilder.append("Schema");
        }
        if (bl2) {
            stringBuilder.append("Procedure");
        }
        if (bl3) {
            stringBuilder.append("Column");
        }
        if (null == this.m_contextMap.get(stringBuilder.toString())) {
            String string4 = PGCatalogQueryBuilder.buildProcedureColumnsQueryForOldPostgres(map, this.m_settings);
            NoOpJDBCReplacer.EscaperResult escaperResult = PGEscaper.apply(string4, this.m_statement.isCallableStatement(), this.m_spHelper);
            this.m_contextMap.put(stringBuilder.toString(), this.m_client.prepareStatement(escaperResult.getQuery(), null, true));
        }
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
    }

    public IMetadataSource runGetFunctionsJDBC4(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (bl) {
            stringBuilder.append("Schema");
        }
        if (bl2) {
            stringBuilder.append("Function");
        }
        this.prepareCatalogFunction(metadataSourceID, map, stringBuilder.toString());
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
    }

    public IMetadataSource runGetFunctionColumns(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
        String string3 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
        boolean bl = !this.isFilterNullOrEmpty(string);
        boolean bl2 = !this.isFilterNullOrEmpty(string2);
        boolean bl3 = !this.isFilterNullOrEmpty(string3);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STMT_NAME_PREFIX);
        stringBuilder.append(this.getCatalogName(metadataSourceID));
        if (bl) {
            stringBuilder.append("Schema");
        }
        if (bl2) {
            stringBuilder.append("Function");
        }
        if (bl3) {
            stringBuilder.append("Column");
        }
        this.prepareCatalogFunction(metadataSourceID, map, stringBuilder.toString());
        return this.executePreparedCatalogFunction(metadataSourceID, map, this.m_contextMap.get(stringBuilder.toString()));
    }

    public IMetadataSource executePreparedCatalogFunction(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, PGMessagingContext pGMessagingContext) throws ErrorException {
        byte[][] byArray = this.getCatalogQueryParameters(metadataSourceID, map);
        this.m_client.executePreparedStatement(pGMessagingContext, 0, 0, true, byArray, 0);
        return new PGMetadatSourceFromQuery(metadataSourceID, pGMessagingContext, 0, this.m_log);
    }

    private byte[][] getCatalogQueryParameters(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        Object object2;
        int n = map.size();
        int n2 = 0;
        if (!this.m_isDatashare) {
            n2 += map.containsKey((Object)MetadataSourceColumnTag.CATALOG_NAME) ? 1 : 0;
        }
        n2 += map.containsKey((Object)MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME) ? 1 : 0;
        n2 += map.containsKey((Object)MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME) ? 1 : 0;
        for (Object object2 : map.keySet()) {
            if ((object2.equals((Object)MetadataSourceColumnTag.CATALOG_NAME) || object2.equals((Object)MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME) || object2.equals((Object)MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME)) && (!this.m_isDatashare || !object2.equals((Object)MetadataSourceColumnTag.CATALOG_NAME)) || null != map.get(object2) && !map.get(object2).isEmpty()) continue;
            ++n2;
        }
        if (n < n2) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_CATALOG_FUNC_ARG_ERR.name(), map.keySet().toString());
        }
        int n3 = n - n2;
        object2 = new byte[n3][];
        int n4 = 0;
        switch (metadataSourceID) {
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
                String string2 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                if (this.m_isDatashare && null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                }
                if (null != string2 && !string2.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string2);
                }
                return object2;
            }
            case TABLES: {
                String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
                String string3 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string4 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                String string5 = map.get((Object)MetadataSourceColumnTag.TABLE_TYPE);
                if (this.m_isDatashare && null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                }
                if (null != string3 && !string3.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string3);
                }
                if (null != string4 && !string4.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string4);
                }
                if (null != string5 && !string5.isEmpty()) {
                    String[] stringArray = string5.split(",");
                    if (1 < stringArray.length) {
                        object2 = (byte[][])Arrays.copyOf(object2, ((MetadataSourceColumnTag)object2).length - 1 + stringArray.length);
                        int n5 = 0;
                        while (((MetadataSourceColumnTag)object2).length > n4) {
                            object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(stringArray[n5++]);
                        }
                    } else {
                        object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(stringArray[0]);
                    }
                }
                return object2;
            }
            case COLUMNS: {
                String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
                String string6 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string7 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                String string8 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
                if (this.m_isDatashare || this.m_settings.m_hasExtSchemaPatternMatch) {
                    if (this.m_isDatashare && null != string && !string.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                    }
                    if (null != string6 && !string6.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string6);
                    }
                    if (null != string7 && !string7.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string7);
                    }
                    if (null != string8 && !string8.isEmpty()) {
                        object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string8);
                    }
                } else {
                    object2 = new byte[n3 * 2][];
                    if (null != string6 && !string6.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string6);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string6);
                    }
                    if (null != string7 && !string7.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string7);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string7);
                    }
                    if (null != string8 && !string8.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string8);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string8);
                    }
                }
                return object2;
            }
            case FOREIGN_KEYS: {
                String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
                String string9 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
                String string10 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
                String string11 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                }
                if (null != string9 && !string9.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string9);
                }
                if (null != string10 && !string10.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string10.toLowerCase());
                }
                if (null != string11 && !string11.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string11);
                }
                return object2;
            }
            case PRIMARY_KEYS: {
                String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
                String string12 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
                if (null != string12) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string12.toLowerCase());
                }
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string.toLowerCase());
                }
                return object2;
            }
            case PROCEDURES: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string13 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                }
                if (null != string13 && !string13.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string13);
                }
                return object2;
            }
            case FUNCTIONS_JDBC4: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string14 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                }
                if (null != string14 && !string14.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string14);
                }
                return object2;
            }
            case PROCEDURE_COLUMNS: {
                object2 = new byte[2 * n3][];
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string15 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                String string16 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
                if (null != string && !string.isEmpty()) {
                    if (null != string15 && !string15.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string15);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string15);
                        if (null != string16 && !string16.isEmpty()) {
                            object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string16);
                            object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string16);
                        }
                    } else {
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                        if (null != string16 && !string16.isEmpty()) {
                            object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string16);
                            object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string16);
                        }
                    }
                } else if (null != string15 && !string15.isEmpty()) {
                    object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string15);
                    object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string15);
                    if (null != string16 && !string16.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string16);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string16);
                    }
                } else if (null != string16 && !string16.isEmpty()) {
                    object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string16);
                    object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string16);
                }
                return object2;
            }
            case FUNCTION_COLUMNS_JDBC4: {
                object2 = new byte[2 * n3][];
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string17 = map.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME);
                String string18 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
                if (null != string && !string.isEmpty()) {
                    if (null != string17 && !string17.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string17);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string17);
                        if (null != string18 && !string18.isEmpty()) {
                            object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string18);
                            object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string18);
                        }
                    } else {
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                        if (null != string18 && !string18.isEmpty()) {
                            object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string18);
                            object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string18);
                        }
                    }
                } else if (null != string17 && !string17.isEmpty()) {
                    object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string17);
                    object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string17);
                    if (null != string18 && !string18.isEmpty()) {
                        object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string18);
                        object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string18);
                    }
                } else if (null != string18 && !string18.isEmpty()) {
                    object2[n4] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string18);
                    object2[n3 + n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string18);
                }
                return object2;
            }
            case TABLE_PRIVILEGES: {
                String string = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
                String string19 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
                if (null != string && !string.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string);
                }
                if (null != string19 && !string19.isEmpty()) {
                    object2[n4++] = (MetadataSourceColumnTag)DataTypeUtilities.toUTF8ByteArray(string19);
                }
                return object2;
            }
        }
        return null;
    }

    private String getCatalogName(MetadataSourceID metadataSourceID) {
        String string = "";
        switch (metadataSourceID) {
            case CATALOG_ONLY: {
                string = "CatalogOnly";
                break;
            }
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                string = "SchemaOnly";
                break;
            }
            case TABLES: {
                string = "Tables";
                break;
            }
            case COLUMNS: {
                string = "Columns";
                break;
            }
            case FOREIGN_KEYS: {
                string = "ForeignKeys";
                break;
            }
            case PRIMARY_KEYS: {
                string = "PrimaryKeys";
                break;
            }
            case TABLE_PRIVILEGES: {
                string = "TablePrivileges";
                break;
            }
            case PROCEDURES: {
                string = "Procedures";
                break;
            }
            case PROCEDURE_COLUMNS: {
                string = "ProcedureColumns";
                break;
            }
            case FUNCTIONS_JDBC4: {
                string = "Functions";
                break;
            }
            case FUNCTION_COLUMNS_JDBC4: {
                string = "FunctionColumns";
                break;
            }
        }
        return string;
    }

    private boolean isFilterNullOrEmpty(String string) {
        return null == string || string.equals("");
    }

    private void prepareCatalogFunction(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string) throws ErrorException {
        if (null == this.m_contextMap.get(string)) {
            String string2 = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceID, map, this.m_settings, this.m_isDatashare);
            NoOpJDBCReplacer.EscaperResult escaperResult = PGEscaper.apply(string2, this.m_statement.isCallableStatement(), this.m_spHelper);
            this.m_contextMap.put(string, this.m_client.prepareStatement(escaperResult.getQuery(), null, true));
        }
    }
}

