/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.antlr4.sql.escaper.AbstractStoredProcedureHelper;
import com.amazon.antlr4.sql.escaper.NoOpJDBCReplacer;
import com.amazon.antlr4.sql.escaper.ProcessedStatement;
import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.exceptions.DefaultParamException;
import com.amazon.dsi.exceptions.ParamAlreadyPushedException;
import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.redshift.ExecuteMode;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.CallablePreparedOrAtomicExecuteTask;
import com.amazon.redshift.dataengine.ExpectedResult;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.dataengine.PGEscaper;
import com.amazon.redshift.dataengine.PGThreadFactory;
import com.amazon.redshift.dataengine.metadata.PGParameterMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogLevel;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.support.exceptions.GeneralException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PGBatchQueryExecutor
extends PGAbstractQueryExecutor {
    private Map<PGMessagingContext, Integer> m_parameterCountPerQuery = new HashMap<PGMessagingContext, Integer>();
    private List<ProcessedStatement> m_queries;
    private String m_query;
    private int m_totalParamCount;

    public PGBatchQueryExecutor(List<String> list, PGClient pGClient, ILogger iLogger, boolean bl, PGJDBCStatement pGJDBCStatement, int n, AbstractStoredProcedureHelper abstractStoredProcedureHelper, boolean bl2) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, list, pGClient);
        this.m_isDirectExecute = bl;
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_statement = pGJDBCStatement;
        this.m_socketTimeoutMS = n;
        this.m_contexts = new ArrayList();
        this.m_rowCountArrayExpected = bl2;
        STMT_CANCEL_STATE_UPDATER.set(this, false);
        this.m_cancelCalledBeforeExecute = false;
        this.m_queries = new ArrayList<ProcessedStatement>();
        StringBuilder stringBuilder = new StringBuilder();
        NoOpJDBCReplacer.EscaperResult escaperResult = null;
        for (String string : list) {
            escaperResult = PGEscaper.apply(string, false, abstractStoredProcedureHelper);
            if (!escaperResult.getContainsCallWithOutput()) {
                this.m_queries.addAll(PGEscaper.apply(string, this.m_statement.isCallableStatement(), abstractStoredProcedureHelper).getStatements());
                stringBuilder.append(string);
                stringBuilder.append(',');
                continue;
            }
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR, new String[]{"A batch cannot contain a CALL statement", string});
            throw errorException;
        }
        this.m_query = stringBuilder.toString();
        this.createMessaginContexts();
    }

    public PGBatchQueryExecutor(String string, List<ProcessedStatement> list, PGClient pGClient, ILogger iLogger, boolean bl, PGJDBCStatement pGJDBCStatement, int n, boolean bl2) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, string, pGClient);
        this.m_query = string;
        this.m_queries = list;
        this.m_isDirectExecute = bl;
        this.m_log = iLogger;
        this.m_client = pGClient;
        this.m_statement = pGJDBCStatement;
        this.m_socketTimeoutMS = n;
        this.m_contexts = new ArrayList();
        this.m_rowCountArrayExpected = bl2;
        STMT_CANCEL_STATE_UPDATER.set(this, false);
        this.m_cancelCalledBeforeExecute = false;
        this.createMessaginContexts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws ErrorException {
        int n;
        int n2;
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        this.m_prepareStage = false;
        if (null != this.m_statement.getExpectedResult() && this.m_statement.getExpectedResult() == ExpectedResult.SingleResult) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_MULTIPLE_COMMAND_EXECUTE_QUERY_ERR.name(), new String[]{this.m_query});
        }
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            n2 = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        try {
            n = this.m_statement.getProperty(2).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Max rows retrieval failed", this.m_query}, (Throwable)exception);
            throw errorException;
        }
        ++this.m_currentExecuteIndex;
        try {
            HashMap<PGMessagingContext, ArrayList<byte[][]>> hashMap = this.buildParameterSets(executionContexts);
            Object object = this.m_statement.getTransactionLock();
            object.lock();
            try {
                Object object2;
                PGCoreUtils.TransactionVerb transactionVerb = PGCoreUtils.TransactionVerb.NONE;
                this.checkCancelled();
                int n3 = this.getQueryTimeout();
                CallablePreparedOrAtomicExecuteTask callablePreparedOrAtomicExecuteTask = new CallablePreparedOrAtomicExecuteTask(this.m_client, this.m_contexts, this.m_queries, hashMap, executionContexts.getCount(), n, n2, this.m_statement.getWarningListener(), n3, ExecuteMode.BATCH, this);
                Future<Boolean> future = this.m_executor.submit(callablePreparedOrAtomicExecuteTask);
                try {
                    if (0 != n3) {
                        future.get(n3, TimeUnit.MILLISECONDS);
                    } else {
                        future.get();
                    }
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause().getClass().equals(ErrorException.class)) {
                        ErrorException errorException = (ErrorException)executionException.getCause();
                        String[] stringArray = errorException.getMessageParams();
                        if (0 < stringArray.length && stringArray[0].toLowerCase().contains("cancelled")) {
                            LogUtilities.logError("Query was cancelled", this.m_log);
                        }
                        throw errorException;
                    }
                    if (executionException.getCause().getClass().equals(GeneralException.class)) {
                        object2 = (GeneralException)executionException.getCause();
                        String string = ((ErrorException)object2).getMessageKeyOrText();
                        if (null != string && (string.equalsIgnoreCase("CHANNEL_SERVER_CLOSED") || string.equalsIgnoreCase("PG_CONNECTION_LOST_ERR"))) {
                            LogUtilities.logError("Execution failed due to connection lost", this.m_log);
                            throw object2;
                        }
                    } else {
                        if (!this.m_cancelCalledBeforeExecute) {
                            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Batch execution failed ", this.m_query}, (Throwable)executionException);
                        }
                        LogUtilities.logError("Cancel was called before query is in execution. Batch execution failed.", this.m_log);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (((Boolean)STMT_CANCEL_STATE_UPDATER.get(this)).booleanValue()) {
                        this.m_client.cancelQuery(this.m_query);
                    }
                    for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                        pGMessagingContext.m_isCanceled.set(true);
                    }
                    if (null != future && !future.isDone()) {
                        boolean bl = future.cancel(true);
                        if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                            LogUtilities.logDebug("Future result of batch execution was cancelled successfully: " + bl, this.m_log);
                        }
                    }
                    LogUtilities.logError("Query has been interrupted", this.m_log);
                    throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Batch query execution has been interrupted and failed ", this.m_query}, (Throwable)interruptedException);
                }
                catch (TimeoutException timeoutException) {
                    this.m_client.cancelQuery(this.m_query);
                    for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                        pGMessagingContext.m_isCanceled.set(true);
                    }
                    if (null != future && !future.isDone()) {
                        boolean bl = future.cancel(true);
                        if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                            LogUtilities.logDebug("Future result of batch execution was cancelled successfully: " + bl, this.m_log);
                        }
                    }
                    LogUtilities.logError("Query has timed out", this.m_log);
                    throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_SOCKET_TIMEOUT_ERR.name(), ExceptionType.TIME_OUT);
                }
                catch (Exception exception) {
                    if (!this.m_cancelCalledBeforeExecute) {
                        throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Batch query execution failed ", this.m_query}, (Throwable)exception);
                    }
                    LogUtilities.logError("Cancel was called before query is in execution. Batch query execution failed.", this.m_log);
                }
                for (int i = 0; i < this.m_queries.size(); ++i) {
                    object2 = (PGMessagingContext)this.m_contexts.get(i);
                    transactionVerb = this.m_client.getTransactionVerbOfMessage((PGMessagingContext)object2);
                    if (PGCoreUtils.TransactionVerb.NONE == transactionVerb) continue;
                    ((PGMessagingContext)this.m_contexts.get(i)).closeOperation();
                    this.m_statement.notifyTransaction(transactionVerb);
                }
            }
            finally {
                if (null != object) {
                    object.unlock();
                }
            }
        }
        catch (Exception exception) {
            --this.m_currentExecuteIndex;
            if (!(exception instanceof ErrorException)) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
            throw (ErrorException)exception;
        }
        this.m_statement.pushContexts(this.m_contexts);
        for (Object object : this.m_contexts) {
            ((InboundMessagesPipeline)object).addSocketCloseListener(this);
        }
    }

    private HashMap<PGMessagingContext, ArrayList<byte[][]>> buildParameterSets(ExecutionContexts executionContexts) throws ParamAlreadyPushedException, DefaultParamException, ErrorException {
        ArrayList<byte[]> arrayList;
        Object object;
        Object object2;
        int n = executionContexts.getMetadata().size();
        HashMap hashMap = new HashMap(this.m_contexts.size());
        if (n != 0) {
            object2 = executionContexts.contextIterator();
            int n2 = 0;
            while (object2.hasNext()) {
                ExecutionContext object3 = (ExecutionContext)object2.next();
                object = null;
                for (ParameterInputValue parameterInputValue : object3.getInputs()) {
                    arrayList = null;
                    object = ((PGParameterMetadata)parameterInputValue.getMetadata()).getContext();
                    ArrayList<ArrayList<byte[]>> arrayList2 = (ArrayList<ArrayList<byte[]>>)hashMap.get(object);
                    if (null == arrayList2) {
                        arrayList2 = new ArrayList<ArrayList<byte[]>>(executionContexts.getCount());
                        for (int i = 0; i < executionContexts.getCount(); ++i) {
                            arrayList2.add(null);
                        }
                        hashMap.put(object, arrayList2);
                    } else {
                        arrayList = (List)arrayList2.get(n2);
                    }
                    if (null == arrayList) {
                        arrayList = new ArrayList<byte[]>();
                        arrayList2.set(n2, arrayList);
                    }
                    arrayList.add(PGDataTypeUtilities.toUTF8ByteArray(parameterInputValue.getData()));
                }
                ++n2;
            }
        }
        object2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            object = null;
            ArrayList arrayList3 = (ArrayList)entry.getValue();
            if (null != arrayList3) {
                Iterator iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    arrayList = (ArrayList<byte[]>)iterator.next();
                    if (null == arrayList) continue;
                    if (null == object) {
                        object = new ArrayList();
                    }
                    ((ArrayList)object).add(arrayList.toArray((T[])new byte[0][0]));
                }
            }
            ((HashMap)object2).put(entry.getKey(), object);
        }
        return object2;
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ArrayList<ParameterMetadata> arrayList = new ArrayList<ParameterMetadata>();
        List<ParameterMetadata> list = null;
        int n = 0;
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            if (this.m_statement.isCallableStatement()) {
                if (n < this.m_queries.size()) {
                    list = this.getStoredProcParamMetadata(this.m_queries.get(n), pGMessagingContext);
                    ++n;
                }
            } else {
                list = this.getMetadataForParameters(pGMessagingContext);
            }
            this.m_parameterCountPerQuery.put(pGMessagingContext, list.size());
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return this.m_totalParamCount;
    }

    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        if (((Boolean)STMT_CANCEL_STATE_UPDATER.get(this)).booleanValue()) {
            this.m_client.cancelQuery(this.m_query);
        } else {
            if (this.m_log.getLogLevel().equals((Object)LogLevel.TRACE) || this.m_log.getLogLevel().equals((Object)LogLevel.DEBUG)) {
                LogUtilities.logDebug("Cancel was ignored because statement is not in execute", this.m_log);
            }
            this.m_cancelCalledBeforeExecute = true;
        }
        for (PGMessagingContext pGMessagingContext : this.m_contexts) {
            pGMessagingContext.m_isCanceled.set(true);
        }
    }

    @Override
    protected int getParamCountForContext(PGMessagingContext pGMessagingContext) {
        return this.m_parameterCountPerQuery.get(pGMessagingContext);
    }

    private void createMessaginContexts() throws ErrorException {
        PGThreadFactory pGThreadFactory = new PGThreadFactory("PGThreadPool" + s_threadPoolCounter.getAndIncrement());
        this.m_executor = Executors.newSingleThreadExecutor(pGThreadFactory);
        if (!this.m_isDirectExecute) {
            boolean bl = this.m_queries.size() > 1;
            for (ProcessedStatement processedStatement : this.m_queries) {
                PGMessagingContext pGMessagingContext = this.m_client.prepareStatement(processedStatement.getStatementText(), this.m_statement.getWarningListener(), bl);
                pGMessagingContext.addSocketCloseListener(this);
                pGMessagingContext.setFinalCommandInBatch(false);
                this.m_contexts.add(pGMessagingContext);
                this.m_totalParamCount += processedStatement.getParamCount();
            }
            ((PGMessagingContext)this.m_contexts.get(this.m_contexts.size() - 1)).setFinalCommandInBatch(true);
        }
        this.m_statement.pushContexts(this.m_contexts);
    }
}

