/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.antlr4.sql.escaper.ProcessedStatement;
import com.amazon.redshift.ExecuteMode;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogLevel;
import com.amazon.support.LogUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

public class CallablePreparedOrAtomicExecuteTask
implements Callable<Boolean> {
    private PGClient m_client;
    private List<PGMessagingContext> m_contexts;
    private List<ProcessedStatement> m_statements;
    private HashMap<PGMessagingContext, ArrayList<byte[][]>> m_paramSets = null;
    private byte[][] m_parameterValues = null;
    private int m_numberOfParameterSets;
    private int m_fetchSize;
    private int m_maxRows;
    private IWarningListener m_stmtWarningListener;
    private int m_queryTimeoutMs;
    private ExecuteMode m_mode;
    private boolean m_disableBRM;
    private PGAbstractQueryExecutor m_queryExecutor;

    CallablePreparedOrAtomicExecuteTask(PGClient pGClient, List<PGMessagingContext> list, byte[][] byArray, int n, int n2, int n3, boolean bl, ExecuteMode executeMode, PGAbstractQueryExecutor pGAbstractQueryExecutor) {
        this.m_client = pGClient;
        this.m_contexts = list;
        this.m_parameterValues = byArray;
        this.m_fetchSize = n2;
        this.m_maxRows = n;
        this.m_queryTimeoutMs = n3;
        this.m_mode = executeMode;
        this.m_disableBRM = bl;
        this.m_queryExecutor = pGAbstractQueryExecutor;
    }

    CallablePreparedOrAtomicExecuteTask(PGClient pGClient, List<PGMessagingContext> list, List<ProcessedStatement> list2, HashMap<PGMessagingContext, ArrayList<byte[][]>> hashMap, int n, int n2, int n3, IWarningListener iWarningListener, int n4, ExecuteMode executeMode, PGAbstractQueryExecutor pGAbstractQueryExecutor) {
        this.m_client = pGClient;
        this.m_contexts = list;
        this.m_paramSets = hashMap;
        this.m_numberOfParameterSets = n;
        this.m_statements = list2;
        this.m_fetchSize = n3;
        this.m_maxRows = n2;
        this.m_stmtWarningListener = iWarningListener;
        this.m_queryTimeoutMs = n4;
        this.m_mode = executeMode;
        this.m_queryExecutor = pGAbstractQueryExecutor;
    }

    @Override
    public Boolean call() throws Exception {
        if (this.m_mode.equals((Object)ExecuteMode.PREPARED)) {
            PGMessagingContext pGMessagingContext = this.m_contexts.get(0);
            this.m_client.executePreparedStatement(pGMessagingContext, this.m_fetchSize, this.m_maxRows, this.m_disableBRM, this.m_parameterValues, this.m_queryTimeoutMs, false);
            this.m_queryExecutor.setStmtInQueryState();
            if (this.m_client.getClientLogger().isEnabled() && (this.m_client.getClientLogger().getLogLevel().equals((Object)LogLevel.TRACE) || this.m_client.getClientLogger().getLogLevel().equals((Object)LogLevel.DEBUG))) {
                LogUtilities.logDebug("Prepared query execution got to error checking for query: " + pGMessagingContext.m_query, this.m_client.getClientLogger());
            }
            this.m_client.handleErrorsPrepareExecute(pGMessagingContext);
        } else if (this.m_mode.equals((Object)ExecuteMode.BATCH)) {
            boolean bl = false;
            if (0 == this.m_contexts.size()) {
                bl = true;
            }
            this.m_client.executeAtomicStatement(this.m_contexts, this.m_statements, this.m_paramSets, this.m_numberOfParameterSets, this.m_maxRows, this.m_fetchSize, this.m_stmtWarningListener, this.m_queryTimeoutMs, false);
            this.m_queryExecutor.setStmtInQueryState();
            if (this.m_client.getClientLogger().isEnabled() && (this.m_client.getClientLogger().getLogLevel().equals((Object)LogLevel.TRACE) || this.m_client.getClientLogger().getLogLevel().equals((Object)LogLevel.DEBUG))) {
                LogUtilities.logDebug("Batch query execution got to error checking for the batch starting with query: " + this.m_statements.get(0).getStatementText(), this.m_client.getClientLogger());
            }
            this.m_client.handleAtomicStmtErrors(this.m_contexts, bl);
            if (bl) {
                for (PGMessagingContext pGMessagingContext : this.m_contexts) {
                    pGMessagingContext.m_columnsIsNullResultSet = this.m_client.createColumnsIsNullResultSet(pGMessagingContext);
                }
            }
        }
        return true;
    }
}

