/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc42;

import com.amazon.jdbc.common.AbstractDataSource;
import com.amazon.jdbc.common.JDBCObjectFactory;
import com.amazon.jdbc.jdbc42.JDBC42AbstractDataSource;
import com.amazon.redshift.PGInfo;
import com.amazon.redshift.common.PGCommonDataSource;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCPropertyKey;
import com.amazon.redshift.core.jdbc42.PGJDBC42ObjectFactory;
import java.util.Arrays;
import java.util.Properties;

public class PGJDBC42DataSource
extends JDBC42AbstractDataSource
implements PGCommonDataSource {
    private String m_language = null;
    protected boolean m_isUsingOpenSourceSubProtocol = false;

    @Override
    protected boolean acceptsSubProtocol(String string) {
        boolean bl = "postgresql".equals(string);
        if (bl || Arrays.asList(PGInfo.PG_SUBPROTOCOL_NAMES).contains(string)) {
            this.m_isUsingOpenSourceSubProtocol = bl;
            return true;
        }
        return false;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    @Override
    public void setLanguage(String string) {
        this.m_language = string;
    }

    @Override
    protected JDBCObjectFactory createJDBCObjectFactory() {
        return new PGJDBC42ObjectFactory();
    }

    @Override
    public String getLogLevelString() {
        return this.getLogLevel().name();
    }

    @Override
    protected Properties getProperties() {
        Properties properties = super.getProperties();
        if (null != this.m_language) {
            properties.put((Object)PGJDBCPropertyKey.LANGUAGE, this.m_language);
        }
        return properties;
    }

    @Override
    public String getSubProtocol() {
        return null;
    }

    @Override
    protected boolean parseSubName(String string, Properties properties) {
        return PGCoreUtils.parseSubName(string, properties, this.m_isUsingOpenSourceSubProtocol);
    }

    static {
        AbstractDataSource.initialize(PGJDBCDriver.class.getName());
    }
}

