/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.core.PGJDBCPropertyKey;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.ProfileStaticCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginProfilesConfigFile
extends ProfilesConfigFile {
    private static final String PROFILE_PREFIX = "profile ";
    private Map<String, CredentialsHolder> cache = new ConcurrentHashMap<String, CredentialsHolder>();
    private PGJDBCSettings m_settings;
    private ILogger m_log;

    public PluginProfilesConfigFile(PGJDBCSettings pGJDBCSettings, ILogger iLogger) {
        this.m_settings = pGJDBCSettings;
        this.m_log = iLogger;
    }

    public CredentialsHolder getCredentials(String string) {
        Object object;
        Object object2;
        CredentialsHolder credentialsHolder = this.cache.get(string);
        if (credentialsHolder == null) {
            credentialsHolder = this.cache.get(PROFILE_PREFIX + string);
        }
        if (credentialsHolder != null && !credentialsHolder.isExpired()) {
            Date date = new Date();
            LogUtilities.logInfo(date + ": Using existing entry for PluginProfilesConfigFile.getCredentials cache with expiration " + credentialsHolder.getExpiration(), this.m_log);
            return credentialsHolder;
        }
        Map map = this.getAllBasicProfiles();
        BasicProfile basicProfile = (BasicProfile)map.get(string);
        if (basicProfile == null) {
            basicProfile = (BasicProfile)map.get(PROFILE_PREFIX + string);
        }
        if (basicProfile == null) {
            throw new SdkClientException("No AWS profile named '" + string + "'");
        }
        if (basicProfile.isRoleBasedProfile()) {
            String string2 = basicProfile.getRoleSourceProfile();
            CredentialsHolder credentialsHolder2 = this.getCredentials(string2);
            AWSStaticCredentialsProvider aWSStaticCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentialsHolder2);
            credentialsHolder = this.assumeRole(basicProfile, (AWSCredentialsProvider)aWSStaticCredentialsProvider);
            credentialsHolder.setMetadata(credentialsHolder2.getMetadata());
            this.cache.put(string, credentialsHolder);
            Date date = new Date();
            LogUtilities.logInfo(date + ": Adding new role based entry for PluginProfilesConfigFile.getCredentials cache with expiration " + credentialsHolder.getExpiration(), this.m_log);
            return credentialsHolder;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = basicProfile.getPropertyValue("plugin_name");
        if (!StringUtils.isNullOrEmpty((String)string7)) {
            try {
                object2 = Class.forName(string7).asSubclass(AWSCredentialsProvider.class);
                object = (AWSCredentialsProvider)((Class)object2).newInstance();
                if (object instanceof IPlugin) {
                    String string2;
                    IPlugin iPlugin = (IPlugin)object;
                    iPlugin.setILogger(this.m_log);
                    Map map2 = basicProfile.getProperties();
                    for (Map.Entry entry : map2.entrySet()) {
                        string2 = ((String)entry.getKey()).toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(string2)) continue;
                        String string8 = (String)entry.getValue();
                        iPlugin.addParameter(string2, string8);
                        if (PGJDBCPropertyKey.DB_USER.equalsIgnoreCase(string2)) {
                            string3 = string8;
                            continue;
                        }
                        if (PGJDBCPropertyKey.DB_GROUPS.equalsIgnoreCase(string2)) {
                            string5 = string8;
                            continue;
                        }
                        if (PGJDBCPropertyKey.FORCE_LOWERCASE.equalsIgnoreCase(string2)) {
                            string6 = string8;
                            continue;
                        }
                        if (!PGJDBCPropertyKey.USER_AUTOCREATE.equalsIgnoreCase(string2)) continue;
                        string4 = string8;
                    }
                    for (Map.Entry<Object, Object> entry : this.m_settings.m_pluginArgs.entrySet()) {
                        string2 = ((String)entry.getKey()).toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(string2)) continue;
                        iPlugin.addParameter((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                credentialsHolder = CredentialsHolder.newInstance(object.getCredentials());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new SdkClientException("Invalid plugin: '" + string7 + "'");
            }
        } else {
            object2 = new ProfileStaticCredentialsProvider(basicProfile).getCredentials();
            credentialsHolder = CredentialsHolder.newInstance((AWSCredentials)object2);
        }
        object2 = credentialsHolder.getMetadata();
        if (null == object2) {
            object2 = new CredentialsHolder.IamMetadata();
        }
        if (null != string3) {
            ((CredentialsHolder.IamMetadata)object2).setProfileDbUser(string3);
        }
        if (null != string4) {
            ((CredentialsHolder.IamMetadata)object2).setAutoCreate(Boolean.valueOf(string4));
        }
        if (null != string5) {
            ((CredentialsHolder.IamMetadata)object2).setDbGroups(string5);
        }
        if (null != string6) {
            ((CredentialsHolder.IamMetadata)object2).setForceLowercase(Boolean.valueOf(string6));
        }
        credentialsHolder.setMetadata((CredentialsHolder.IamMetadata)object2);
        this.cache.put(string, credentialsHolder);
        object = new Date();
        LogUtilities.logInfo(object + ": Adding new profile based entry for PluginProfilesConfigFile.getCredentials cache with expiration " + credentialsHolder.getExpiration(), this.m_log);
        return credentialsHolder;
    }

    private CredentialsHolder assumeRole(BasicProfile basicProfile, AWSCredentialsProvider aWSCredentialsProvider) {
        AWSSecurityTokenServiceClientBuilder aWSSecurityTokenServiceClientBuilder = AWSSecurityTokenServiceClientBuilder.standard();
        if (!StringUtils.isNullOrEmpty((String)this.m_settings.m_awsRegion)) {
            aWSSecurityTokenServiceClientBuilder.setRegion(this.m_settings.m_awsRegion);
        }
        AWSSecurityTokenService aWSSecurityTokenService = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)aWSSecurityTokenServiceClientBuilder.withCredentials(aWSCredentialsProvider)).build();
        String string = basicProfile.getRoleArn();
        String string2 = basicProfile.getRoleSessionName();
        if (StringUtils.isNullOrEmpty((String)string2)) {
            string2 = "redshift-jdbc-" + System.currentTimeMillis();
        }
        String string3 = basicProfile.getRoleExternalId();
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(string).withRoleSessionName(string2);
        if (!StringUtils.isNullOrEmpty((String)string3)) {
            assumeRoleRequest = assumeRoleRequest.withExternalId(string3);
        }
        AssumeRoleResult assumeRoleResult = aWSSecurityTokenService.assumeRole(assumeRoleRequest);
        Credentials credentials = assumeRoleResult.getCredentials();
        Date date = credentials.getExpiration();
        BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        return CredentialsHolder.newInstance((AWSCredentials)basicSessionCredentials, date);
    }
}

