/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public enum PGJDBCPropertyKey {
    USERNAME("UID"),
    USERNAME_ALT("user"),
    PASSWORD("PWD"),
    PASSWORD_ALT("password"),
    LANGUAGE("Language"),
    MODE("Mode"),
    HOST_KEY("Host"),
    PORT_KEY("Port"),
    SCHEMA_KEY("ConnSchema"),
    DEFAULT_STRING_LENGTH_KEY("DefaultStringColumnLength"),
    AUTH_MECH_KEY("AuthMech"),
    KRB_REALM_KEY("KrbRealm"),
    KRB_HOST_FQDN_KEY("KrbHostFQDN"),
    KRB_SERVICE_NAME_KEY("KrbServiceName"),
    SSL_KEYSTORE_KEY("SSLKeyStore"),
    SSL_KEYSTORE_PWD_KEY("SSLKeyStorePwd"),
    SSL_TRUSTSTORE_PATH_KEY("SSLTrustStorePath"),
    SSL_TRUSTSTORE_PWD_KEY("SSLTruststore "),
    DELEGATION_UID_KEY("DelegationUID"),
    LOGIN_TIMEOUT_KEY("loginTimeout"),
    ROWS_FETCHED_PER_BLOCK_KEY("RowsFetchedPerBlock"),
    BLOCKING_ROWS_MODE("BlockingRowsMode"),
    TCP_KEEPALIVE_MINUTES("TCPKeepAliveMinutes"),
    FILTER_LEVEL("FilterLevel"),
    TCP_KEEP_ALIVE("tcpKeepAlive"),
    SSL_FACTORY("sslfactory"),
    SSL_MODE("sslmode"),
    SSL_MODE_VERIFY_FULL("verify-full"),
    SSL_MODE_VERIFY_CA("verify-ca"),
    SSL("ssl"),
    SSL_KEY("sslkey"),
    SSL_CERT("sslcert"),
    SSL_ROOT_CERT("sslrootcert"),
    SSL_PASSWORD("sslpassword"),
    SOCKET_TIMEOUT("socketTimeout"),
    DSI_LOG_LEVEL("DSILogLevel"),
    OPEN_SOURCE_OVERRIDE("OpenSourceSubProtocolOverride"),
    UNKNOWN_LENGTH_KEY("unknownLength"),
    DISABLE_IS_VALID_QUERY("DisableIsValidQuery"),
    IAM_AUTH("IAMAuth"),
    CLUSTER_IDENTIFIER("ClusterID"),
    AWS_REGION("Region"),
    ENDPOINT_URL("EndpointUrl"),
    IAM_ACCESS_KEY_ID("AccessKeyID"),
    IAM_SECRET_ACCESS_KEY("SecretAccessKey"),
    IAM_SESSION_TOKEN("SessionToken"),
    AWS_PROFILE("profile"),
    USER_AUTOCREATE("AutoCreate"),
    DB_USER("DbUser"),
    DB_GROUPS("DbGroups"),
    DB_GROUPS_FILTER("DbGroupsFilter"),
    DB_GROUPS_FILTER_ALT("dbgroups_filter"),
    FORCE_LOWERCASE("ForceLowercase"),
    IAM_DURATION("IAMDuration"),
    CREDENTIALS_PROVIDER("plugin_name"),
    SELECTOR_PROVIDER("selectorProvider"),
    SELECTOR_PROVIDER_ARG("selectorProviderArg"),
    READONLY("ReadOnly"),
    QUERY_GROUP("QueryGroup"),
    DATABASE_METADATA_CURRENT_DB_ONLY("DatabaseMetadataCurrentDbOnly");

    private String m_key;
    private static final List<String> s_optionalKeys;
    private static final List<String> s_requiredKeys;
    private static final HashSet<String> s_settingsList;

    private PGJDBCPropertyKey(String string2) {
        this.m_key = string2;
    }

    public String getKey() {
        return this.m_key;
    }

    public boolean equalsIgnoreCase(String string) {
        return null != string && this.m_key.equalsIgnoreCase(string);
    }

    public static List<String> getOptionalKeys() {
        return s_optionalKeys;
    }

    public static List<String> getRequiredKeys() {
        return s_requiredKeys;
    }

    public static HashSet<String> getSettingsList() {
        return s_settingsList;
    }

    public static Map<String, String> getAlternateKeys() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        treeMap.put("LogLevel", DSI_LOG_LEVEL.getKey());
        return treeMap;
    }

    static {
        s_optionalKeys = new ArrayList<String>();
        s_requiredKeys = new ArrayList<String>();
        s_settingsList = new HashSet();
        for (PGJDBCPropertyKey pGJDBCPropertyKey : PGJDBCPropertyKey.values()) {
            String string = pGJDBCPropertyKey.getKey();
            if (USERNAME != pGJDBCPropertyKey && USERNAME_ALT != pGJDBCPropertyKey && PASSWORD != pGJDBCPropertyKey && PASSWORD_ALT != pGJDBCPropertyKey) {
                s_optionalKeys.add(string);
            } else if (USERNAME_ALT != pGJDBCPropertyKey && PASSWORD_ALT != pGJDBCPropertyKey) {
                s_requiredKeys.add(string);
            }
            s_settingsList.add(string.toUpperCase());
        }
        s_optionalKeys.add("DriverLocale");
        s_settingsList.add("DriverLocale".toUpperCase());
        s_optionalKeys.add("LogLevel");
        s_settingsList.add("LogLevel".toUpperCase());
        s_optionalKeys.add("LogNamespace");
        s_settingsList.add("LogNamespace".toUpperCase());
        s_optionalKeys.add("LogPath");
        s_settingsList.add("LogPath".toUpperCase());
    }
}

