/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.antlr4.sql.escaper.AbstractStoredProcedureHelper;
import com.amazon.dsi.core.impl.DSIConnection;
import com.amazon.dsi.core.impl.DSILogger;
import com.amazon.dsi.core.interfaces.IEnvironment;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.core.interfaces.ITransactionStateListener;
import com.amazon.dsi.core.utilities.ClientInfoData;
import com.amazon.dsi.core.utilities.ConnSettingRequestMap;
import com.amazon.dsi.core.utilities.ConnSettingResponseMap;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.BadAttrValException;
import com.amazon.dsi.exceptions.BadAuthException;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.jdbc.common.CommonCoreUtils;
import com.amazon.jdbc.common.ProductInfoHandler;
import com.amazon.redshift.AuthMech;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.core.BrandingPreferences;
import com.amazon.redshift.core.IamHelper;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCPropertyKey;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGEscaper;
import com.amazon.redshift.dataengine.PGJDBCStoredProcedureHelper;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.redshift.ssl.NonValidatingFactory;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PGJDBCConnection
extends DSIConnection {
    private static AtomicInteger s_connectionID = new AtomicInteger(0);
    private PGClient m_postgresqlClient;
    protected ILogger m_log;
    protected ILogger m_driverlog;
    private PGJDBCSettings m_settings;
    PGJDBCStoredProcedureHelper m_spHelper;
    private ProductInfoHandler m_productInfoHandler;
    private String m_serverName = null;
    private String m_serverVersion = null;
    private Boolean m_isRedshiftServer = null;
    private final Lock m_txLock = new ReentrantLock();
    private static final String POSTGRESQL_LOG_NAME_PREFIX = "RedshiftJDBC_connection_";
    private static final int MIN_LOGIN_TIMEOUT = 0;
    private static final int DEFAULT_SOCKET_TIMEOUT = 0;
    private static final int MIN_UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private static final int MAX_UNKNOWN_LENGTH = Integer.MAX_VALUE;

    public PGJDBCConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        HashMap<String, ClientInfoData> hashMap = new HashMap<String, ClientInfoData>();
        hashMap.put("APPLICATIONNAME", new ClientInfoData("ApplicationName", 25, null, "The name of the application currently utilizing the connection."));
        this.m_clientInfoProperties = hashMap;
        String string = PGJDBCDriver.DRIVER_MAJOR_VERSION + "." + PGJDBCDriver.DRIVER_MINOR_VERSION;
        this.m_productInfoHandler = new ProductInfoHandler("SimbaAmazonRedshiftJDBCDriver.lic", "Amazon Redshift JDBC Driver", string, PGJDBCDriver.class);
        try {
            this.setProperty(136, new Variant(2, Character.valueOf('\u0002')));
            this.setProperty(1000, new Variant(5, (short)0));
            this.setProperty(137, new Variant(7, 11L));
            this.setProperty(40, new Variant("N"));
            this.setProperty(151, new Variant("\\"));
            this.setProperty(1012, new Variant(5, (short)1));
        }
        catch (NumericOverflowException numericOverflowException) {
            LogUtilities.logError(numericOverflowException, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), (Throwable)numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            LogUtilities.logError(incorrectTypeException, this.m_log);
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), (Throwable)incorrectTypeException);
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.closeSession();
        }
    }

    public PGClient getPostgresqlClient() {
        return this.m_postgresqlClient;
    }

    public AbstractStoredProcedureHelper getSpHelper() {
        return this.m_spHelper;
    }

    public PGJDBCSettings getConnectionSettings() {
        return this.m_settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        Variant variant;
        Variant variant2;
        Variant variant3;
        Variant variant4;
        Variant variant5;
        Variant variant6;
        Variant variant7;
        Variant variant8;
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        block65: {
            CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, String.valueOf(PGJDBCDriver.DRIVER_MAJOR_VERSION), String.valueOf(PGJDBCDriver.DRIVER_MINOR_VERSION), String.valueOf(PGJDBCDriver.DRIVER_HOT_FIX_VERSION), String.valueOf(PGJDBCDriver.DRIVER_BUILD_NUMBER));
            this.m_productInfoHandler.validateLicense();
            this.m_settings = new PGJDBCSettings();
            this.m_settings.m_loginTimeoutMS = 0;
            this.m_settings.m_rowsFetchedPerBlock = 10000;
            this.m_settings.m_authMech = BrandingPreferences.defaultSslOption;
            this.m_settings.m_newTCPConnectionKeepAliveMinutes = 0;
            this.m_settings.m_disableIsValid = false;
            this.m_settings.m_readonly = false;
            this.m_settings.m_databaseMetadataCurrentDbOnly = true;
            this.m_settings.m_socketTimeoutMS = 0;
            Variant variant9 = this.getOptionalSetting(PGJDBCPropertyKey.BLOCKING_ROWS_MODE.getKey(), connSettingRequestMap);
            if (null != variant9) {
                try {
                    this.m_settings.m_nRowMode = variant9.getInt();
                    if (this.m_settings.m_nRowMode < 0) {
                        this.m_settings.m_nRowMode = 0;
                        this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue(PGJDBCPropertyKey.BLOCKING_ROWS_MODE.getKey()));
                        break block65;
                    }
                    if (0 < this.m_settings.m_nRowMode && 0 > this.m_settings.m_nRowMode) {
                        this.m_settings.m_nRowMode = 0;
                        stringArray = new String[2];
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("The given value is too small. Falling back to the default value ");
                        stringArray[0] = PGJDBCPropertyKey.BLOCKING_ROWS_MODE.getKey();
                        stringArray[1] = ((StringBuilder)object3).toString();
                        object2 = new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), stringArray);
                        this.getWarningListener().postWarning((Warning)object2);
                    }
                }
                catch (Exception exception) {
                    this.m_settings.m_nRowMode = 0;
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue(PGJDBCPropertyKey.BLOCKING_ROWS_MODE.getKey()));
                }
            }
        }
        if (null != (stringArray = this.getOptionalSetting(PGJDBCPropertyKey.SSL_TRUSTSTORE_PATH_KEY.getKey(), connSettingRequestMap))) {
            this.m_settings.m_sslTrustStorePath = stringArray.getString();
        }
        if (null != (object3 = this.getOptionalSetting(PGJDBCPropertyKey.SSL_TRUSTSTORE_PWD_KEY.getKey(), connSettingRequestMap)) && this.m_settings.m_sslTrustStorePath != null) {
            this.m_settings.m_sslTrustStorePwd = ((Variant)object3).getString();
        }
        this.m_settings.m_filterLevel = null != (object2 = this.getOptionalSetting(PGJDBCPropertyKey.FILTER_LEVEL.getKey(), connSettingRequestMap)) ? ((Variant)object2).getString() : "NOTICE";
        Variant variant10 = this.getOptionalSetting(PGJDBCPropertyKey.SELECTOR_PROVIDER.getKey(), connSettingRequestMap);
        if (null != variant10) {
            this.m_settings.m_selectorProvider = variant10.getString();
            object = this.getOptionalSetting(PGJDBCPropertyKey.SELECTOR_PROVIDER_ARG.getKey(), connSettingRequestMap);
            if (null != object) {
                this.m_settings.m_selectorProviderArg = ((Variant)object).getString();
            }
        }
        object = null;
        Variant variant11 = this.getOptionalSetting(PGJDBCPropertyKey.TCP_KEEP_ALIVE.getKey(), connSettingRequestMap);
        if (null != variant11) {
            if (0 == variant11.getString().length() || Boolean.parseBoolean(variant11.getString())) {
                object = true;
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
            } else {
                object = false;
            }
        } else {
            object = true;
            this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
        }
        variant11 = this.getOptionalSetting(PGJDBCPropertyKey.TCP_KEEPALIVE_MINUTES.getKey(), connSettingRequestMap);
        if (null != variant11) {
            try {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = variant11.getInt();
            }
            catch (Exception exception) {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue(PGJDBCPropertyKey.TCP_KEEPALIVE_MINUTES.getKey()));
            }
            if (null != object && (((Boolean)object).booleanValue() && this.m_settings.m_newTCPConnectionKeepAliveMinutes == 0 || !((Boolean)object).booleanValue() && this.m_settings.m_newTCPConnectionKeepAliveMinutes != 0)) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR.name(), new String[]{PGJDBCPropertyKey.TCP_KEEP_ALIVE.getKey(), PGJDBCPropertyKey.TCP_KEEPALIVE_MINUTES.getKey()});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            if (this.m_settings.m_newTCPConnectionKeepAliveMinutes < 0) {
                this.m_settings.m_newTCPConnectionKeepAliveMinutes = 5;
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue(PGJDBCPropertyKey.TCP_KEEPALIVE_MINUTES.getKey()));
            }
        }
        if (null != (variant8 = this.getOptionalSetting(PGJDBCPropertyKey.SOCKET_TIMEOUT.getKey(), connSettingRequestMap))) {
            try {
                int n = variant8.getInt();
                if (n > 0) {
                    this.m_settings.m_socketTimeoutMS = n * 1000;
                } else {
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue(PGJDBCPropertyKey.SOCKET_TIMEOUT.getKey()));
                }
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue(PGJDBCPropertyKey.SOCKET_TIMEOUT.getKey()));
            }
        }
        if (DriverManager.getLoginTimeout() > 0) {
            this.m_settings.m_loginTimeoutMS = DriverManager.getLoginTimeout() * 1000;
        }
        if (null != (variant7 = this.getOptionalSetting(PGJDBCPropertyKey.LOGIN_TIMEOUT_KEY.getKey(), connSettingRequestMap))) {
            try {
                int n = variant7.getInt();
                if (n > 0) {
                    this.m_settings.m_loginTimeoutMS = n * 1000;
                } else {
                    this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue(PGJDBCPropertyKey.LOGIN_TIMEOUT_KEY.getKey()));
                }
            }
            catch (Exception exception) {
                this.getWarningListener().postWarning(this.buildWarningForIncorrectIntPropertyValue(PGJDBCPropertyKey.LOGIN_TIMEOUT_KEY.getKey()));
            }
        }
        if (null != (variant6 = this.getOptionalSetting(PGJDBCPropertyKey.UNKNOWN_LENGTH_KEY.getKey(), connSettingRequestMap))) {
            boolean bl = false;
            try {
                int n = variant6.getInt();
                if (n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
                    this.m_settings.m_unknownLength = n;
                } else {
                    bl = true;
                }
            }
            catch (Exception exception) {
                LogUtilities.logDebug(exception, this.m_log);
                bl = true;
            }
            if (bl) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE_TYPE_OR_RANGE.name(), new String[]{PGJDBCPropertyKey.UNKNOWN_LENGTH_KEY.getKey(), variant6.getString(), String.valueOf(Integer.MIN_VALUE), String.valueOf(Integer.MAX_VALUE)});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        } else {
            this.m_settings.m_unknownLength = Integer.MAX_VALUE;
            LogUtilities.logInfo("unknownLength is null, falls back to default value: " + this.m_settings.m_unknownLength, this.m_log);
        }
        this.m_settings.m_Schema = this.getRequiredSetting(PGJDBCPropertyKey.SCHEMA_KEY.getKey(), connSettingRequestMap).getString();
        Variant variant12 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.HOST_KEY.getKey(), connSettingRequestMap);
        Variant variant13 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.PORT_KEY.getKey(), connSettingRequestMap);
        if (null != variant12) {
            this.m_settings.m_host = variant12.getString();
        }
        if (null != variant13) {
            try {
                this.m_settings.m_port = variant13.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        this.setAuthMech(connSettingRequestMap);
        Variant variant14 = this.getRequiredSetting(PGJDBCPropertyKey.IAM_AUTH.getKey(), connSettingRequestMap);
        this.m_settings.m_iamAuth = Boolean.parseBoolean(variant14.getString());
        if (this.m_settings.m_iamAuth) {
            if (AuthMech.DISABLE == this.m_settings.m_authMech) {
                String string = "IAM authentication requires SSL connection";
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), string);
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            try {
                new IamHelper(this.m_settings, this.m_log).setIAMProperties(connSettingRequestMap);
            }
            catch (ErrorException errorException) {
                LogUtilities.logError(errorException, this.m_log);
            }
        }
        if (null == this.m_settings.m_host) {
            this.m_settings.m_host = this.getRequiredSetting(PGJDBCPropertyKey.HOST_KEY.getKey(), connSettingRequestMap).getString();
        }
        if (0 == this.m_settings.m_port) {
            variant13 = this.getRequiredSetting(PGJDBCPropertyKey.PORT_KEY.getKey(), connSettingRequestMap);
            try {
                this.m_settings.m_port = variant13.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name(), exception.getMessage());
                errorException.initCause(exception);
                throw errorException;
            }
        }
        if (null == this.m_settings.m_username) {
            this.m_settings.m_username = this.getRequiredSetting(PGJDBCPropertyKey.USERNAME.getKey(), connSettingRequestMap).getString();
        }
        if (null == this.m_settings.m_password) {
            this.m_settings.m_password = this.getRequiredSetting(PGJDBCPropertyKey.PASSWORD.getKey(), connSettingRequestMap).getString();
        }
        if (null != (variant5 = this.getOptionalSetting(PGJDBCPropertyKey.SSL_ROOT_CERT.getKey(), connSettingRequestMap))) {
            this.m_settings.m_sslRootCert = variant5.getString();
        }
        if (null != (variant4 = this.getOptionalSetting(PGJDBCPropertyKey.SSL_PASSWORD.getKey(), connSettingRequestMap))) {
            this.m_settings.m_sslPassword = variant4.getString();
        }
        Variant variant15 = this.getOptionalSetting(PGJDBCPropertyKey.SSL_CERT.getKey(), connSettingRequestMap);
        Variant variant16 = this.getOptionalSetting(PGJDBCPropertyKey.SSL_KEY.getKey(), connSettingRequestMap);
        if (null != variant15) {
            this.m_settings.m_sslCert = variant15.getString();
            if (null == variant16) {
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR.name(), PGJDBCPropertyKey.SSL_KEY.getKey());
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
            this.m_settings.m_sslKey = variant16.getString();
        } else if (null != variant16) {
            ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_MISSING_PROPERTY_ERROR.name(), PGJDBCPropertyKey.SSL_CERT.getKey());
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        Variant variant17 = this.getOptionalSetting(PGJDBCPropertyKey.DISABLE_IS_VALID_QUERY.getKey(), connSettingRequestMap);
        if (null != variant17) {
            this.m_settings.m_disableIsValid = Boolean.parseBoolean(variant17.getString());
        }
        if (null != (variant3 = this.getOptionalSetting(PGJDBCPropertyKey.READONLY.getKey(), connSettingRequestMap))) {
            this.m_settings.m_readonly = Boolean.parseBoolean(variant3.getString());
        }
        if (null != (variant2 = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.QUERY_GROUP.getKey(), connSettingRequestMap))) {
            this.m_settings.m_queryGroup = variant2.getString();
        }
        if (null != (variant = PGJDBCConnection.getOptionalConnSetting(PGJDBCPropertyKey.DATABASE_METADATA_CURRENT_DB_ONLY.getKey(), connSettingRequestMap))) {
            this.m_settings.m_databaseMetadataCurrentDbOnly = Boolean.parseBoolean(variant.getString());
        }
        this.m_postgresqlClient = new PGClient(this.m_settings, this.getDriverConnectionLog(), this.getWarningListener());
        if (this.m_settings.m_readonly) {
            try {
                this.setProperty(16, new Variant(3, 1L));
            }
            catch (NumericOverflowException numericOverflowException) {
                LogUtilities.logError(numericOverflowException, this.m_log);
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), numericOverflowException.getMessage());
                errorException.initCause(numericOverflowException);
                throw errorException;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                LogUtilities.logError(incorrectTypeException, this.m_log);
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), incorrectTypeException.getMessage());
                errorException.initCause(incorrectTypeException);
                throw errorException;
            }
        }
        if (null != this.m_settings.m_queryGroup && !this.m_settings.m_queryGroup.isEmpty() && this.isRedshiftServer().booleanValue()) {
            this.m_postgresqlClient.directExecuteImmediately("set query_group to '" + this.m_settings.m_queryGroup + "'", null);
        }
        this.m_spHelper = new PGJDBCStoredProcedureHelper(this);
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new PGJDBCStatement(this, this.m_postgresqlClient, this.m_settings.m_socketTimeoutMS);
    }

    public IStatement prepareStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new PGJDBCStatement(this, this.m_postgresqlClient, this.m_settings.m_socketTimeoutMS);
    }

    @Override
    public void disconnect() throws ErrorException {
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.closeSession();
        }
    }

    @Override
    protected void doReset() throws ErrorException {
    }

    @Override
    public Map<String, ClientInfoData> getClientInfoProperties() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return this.m_clientInfoProperties;
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            this.m_log = new DSILogger(POSTGRESQL_LOG_NAME_PREFIX + Integer.toString(s_connectionID.get()));
            this.m_log.setLocale(this.getLocale());
            if (null == this.m_driverlog) {
                this.m_driverlog = new DSILogger("RedshiftJDBC_connection_ext_" + s_connectionID.getAndIncrement());
                this.m_driverlog.setLocale(this.getLocale());
            }
        }
        return this.m_log;
    }

    public ILogger getDriverConnectionLog() {
        return this.m_driverlog;
    }

    public String getServerVersion() throws ErrorException {
        if (null == this.m_serverVersion) {
            this.initializeProductRelatedDefaultProperties();
        }
        return this.m_serverVersion;
    }

    @Override
    public String toNativeSQL(String string) {
        String string2;
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), string);
        try {
            string2 = PGEscaper.apply(string, true, this.m_spHelper).getQuery();
        }
        catch (Exception exception) {
            this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.PG_QUERY_ESCAPER_ERR.name(), new String[]{string}));
            return string;
        }
        return string2;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, ErrorException {
        connSettingRequestMap.setHiddenKey(PGJDBCPropertyKey.PASSWORD.getKey(), PGJDBCPropertyKey.PASSWORD_ALT.getKey(), PGJDBCPropertyKey.IAM_SECRET_ACCESS_KEY.getKey());
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), connSettingRequestMap);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        for (String string : PGJDBCPropertyKey.getRequiredKeys()) {
            this.verifyRequiredSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        for (String string : PGJDBCPropertyKey.getOptionalKeys()) {
            this.verifyOptionalSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        return connSettingResponseMap;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setProperty(int var1_1, Variant var2_2) throws BadAttrValException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        try {
            switch (var1_1) {
                case 26: {
                    if (1L != var2_2.getLong()) ** GOTO lbl9
                    this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='read uncommitted'", null);
                    ** GOTO lbl20
lbl9:
                    // 1 sources

                    if (2L != var2_2.getLong()) ** GOTO lbl13
                    this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='read committed'", null);
                    ** GOTO lbl20
lbl13:
                    // 1 sources

                    if (4L != var2_2.getLong()) ** GOTO lbl17
                    this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='repeatable read'", null);
                    ** GOTO lbl20
lbl17:
                    // 1 sources

                    if (8L == var2_2.getLong()) {
                        this.m_postgresqlClient.directExecuteImmediately("SET default_transaction_isolation='serializable'", null);
                    }
                }
lbl20:
                // 7 sources

                case 16: {
                    var3_3 = null;
                    var4_6 = this.getProperty(16).getLong();
                    var6_7 = var2_2.getLong();
                    if (var4_6 == var6_7) break;
                    if (1L == var6_7) {
                        this.m_settings.m_readonly = true;
                        var3_3 = "SET SESSION CHARACTERISTICS AS TRANSACTION READ ONLY;";
                    } else if (0L == var6_7) {
                        this.m_settings.m_readonly = false;
                        var3_3 = "SET SESSION CHARACTERISTICS AS TRANSACTION READ WRITE;";
                    }
                    if (this.isRedshiftServer().booleanValue()) {
                        var3_3 = "SET readonly=" + Boolean.toString(this.m_settings.m_readonly);
                    }
                    this.m_postgresqlClient.directExecuteImmediately(var3_3, null);
                    var8_8 = this.m_settings.m_readonly != false ? "Y" : "N";
                    this.setProperty(40, new Variant(0, var8_8));
                }
            }
            super.setProperty(var1_1, var2_2);
        }
        catch (NumericOverflowException var3_4) {
            LogUtilities.logError(var3_4, this.m_log);
            var9_9 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), var3_4.getMessage());
            var9_9.initCause(var3_4);
            throw var9_9;
        }
        catch (IncorrectTypeException var3_5) {
            LogUtilities.logError(var3_5, this.m_log);
            var9_10 = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_SESSION_ERR.name(), var3_5.getMessage());
            var9_10.initCause(var3_5);
            throw var9_10;
        }
    }

    public void setDefaultProperties() throws ErrorException {
        if (null == this.m_isRedshiftServer) {
            this.initializeProductRelatedDefaultProperties();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        PGResultSet pGResultSet = new PGResultSet(this.m_postgresqlClient.directExecute("SELECT supported_value FROM INFORMATION_SCHEMA.SQL_SIZING WHERE sizing_id = 34 or sizing_id = 30 or sizing_id = 31 or sizing_id = 10005 or sizing_id = 32 or sizing_id = 35 or sizing_id = 107 or sizing_id = 97 or sizing_id = 99 or sizing_id = 100 or sizing_id = 101", false, 0, 0, null, false), this.m_log);
        while (pGResultSet.hasMoreRows()) {
            DataWrapper dataWrapper = new DataWrapper();
            pGResultSet.moveToNextRow();
            pGResultSet.getData(0, 0L, -1L, dataWrapper);
            try {
                int n = -1;
                if (null != dataWrapper.getInteger()) {
                    n = PGCoreUtils.safeLongToInt(dataWrapper.getInteger());
                }
                arrayList.add(n);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), (Throwable)incorrectTypeException);
            }
        }
        pGResultSet.close();
        try {
            this.setProperty(101, new Variant(0, "PostgreSQLJDBCDriver"));
            this.setProperty(139, new Variant(0, "User"));
            this.setProperty(22, new Variant(0, this.m_settings.m_Schema));
            this.setProperty(58, new Variant(0, "\""));
            this.setProperty(80, new Variant(0, "N"));
            this.setProperty(69, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(0)).intValue())));
            this.setProperty(71, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(1)).intValue())));
            this.setProperty(72, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(2)).intValue())));
            this.setProperty(73, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(3)).intValue())));
            this.setProperty(66, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(4)).intValue())));
            this.setProperty(68, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(5)).intValue())));
            this.setProperty(75, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(6)).intValue())));
            this.setProperty(76, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(7)).intValue())));
            this.setProperty(81, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(8)).intValue())));
            this.setProperty(83, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(9)).intValue())));
            this.setProperty(85, new Variant(2, Character.valueOf((char)((Integer)arrayList.get(10)).intValue())));
            this.setProperty(41, new Variant(0, this.m_serverName));
            this.setProperty(42, new Variant(0, this.m_serverVersion));
            this.setProperty(74, new Variant(2, Character.valueOf('\u0001')));
        }
        catch (Exception exception) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), exception.getCause());
        }
    }

    private void initializeProductRelatedDefaultProperties() throws ErrorException {
        String string;
        PGResultSet pGResultSet = new PGResultSet(this.m_postgresqlClient.directExecute("SELECT character_value, version() FROM INFORMATION_SCHEMA.SQL_IMPLEMENTATION_INFO WHERE implementation_info_id = '17' or implementation_info_id = '18'", false, 0, 0, null, true), this.m_log);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (pGResultSet.hasMoreRows()) {
            DataWrapper dataWrapper = new DataWrapper();
            if (!pGResultSet.moveToNextRow()) continue;
            pGResultSet.getData(0, 0L, -1L, dataWrapper);
            try {
                string = dataWrapper.getVarChar();
                if (null != string) {
                    arrayList.add(string);
                } else {
                    arrayList.add("");
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), (Throwable)incorrectTypeException);
            }
            pGResultSet.getData(1, 0L, -1L, dataWrapper);
            try {
                string = dataWrapper.getVarChar();
                if (null != string && string.matches("(?i:.*redshift.*)")) {
                    this.m_isRedshiftServer = true;
                    continue;
                }
                this.m_isRedshiftServer = false;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                LogUtilities.logError(incorrectTypeException, this.m_log);
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), incorrectTypeException.getCause());
            }
        }
        pGResultSet.close();
        this.m_serverName = (String)arrayList.get(0);
        this.m_serverVersion = (String)arrayList.get(1);
        int n = Integer.parseInt(this.m_serverVersion.split("\\.")[0]);
        if (n >= 9) {
            this.m_postgresqlClient.directExecuteImmediately("SET extra_float_digits = 3", null);
        }
        if (this.m_isRedshiftServer.booleanValue()) {
            string = "SET application_name = 'JDBC-" + PGJDBCDriver.DRIVER_MAJOR_VERSION + '.' + PGJDBCDriver.DRIVER_MINOR_VERSION + '.' + PGJDBCDriver.DRIVER_HOT_FIX_VERSION + '.' + PGJDBCDriver.DRIVER_BUILD_NUMBER + '\'';
            try {
                this.m_postgresqlClient.directExecuteImmediately(string, null);
            }
            catch (ErrorException errorException) {
                // empty catch block
            }
        }
    }

    public Boolean isRedshiftServer() throws ErrorException {
        if (null == this.m_isRedshiftServer) {
            this.initializeProductRelatedDefaultProperties();
        }
        return this.m_isRedshiftServer;
    }

    @Override
    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("BEGIN;", null);
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("COMMIT;", null);
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        super.registerWarningListener(iWarningListener);
        if (null != this.m_postgresqlClient) {
            this.m_postgresqlClient.registerWarningListener(iWarningListener);
        }
    }

    @Override
    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_postgresqlClient.directExecuteImmediately("ROLLBACK;", null);
    }

    final Lock getTransactionLock() {
        return this.m_txLock;
    }

    final ITransactionStateListener getTransactionStateListener() {
        return this.m_transactionListener;
    }

    private void setAuthMech(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        boolean bl = false;
        boolean bl2 = false;
        Variant variant = this.getOptionalSetting(PGJDBCPropertyKey.SSL.getKey(), connSettingRequestMap);
        if (null != variant) {
            if (Boolean.parseBoolean(variant.getString()) || variant.getString().equals("")) {
                bl = true;
                this.m_settings.m_authMech = AuthMech.VERIFY_CA;
            } else if (!Boolean.parseBoolean(variant.getString())) {
                bl2 = true;
            }
        }
        Variant variant2 = this.getOptionalSetting(PGJDBCPropertyKey.AUTH_MECH_KEY.getKey(), connSettingRequestMap);
        AuthMech authMech = null;
        if (null != variant2) {
            try {
                authMech = AuthMech.valueOf(variant2.getString().toUpperCase().trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < AuthMech.values().length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append((Object)AuthMech.values()[i]);
                }
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{PGJDBCPropertyKey.AUTH_MECH_KEY.getKey(), stringBuffer.toString()});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (null != authMech) {
            bl3 = true;
        }
        if ((bl && AuthMech.DISABLE == authMech || bl && AuthMech.ALLOW == authMech || bl && AuthMech.PREFER == authMech || bl2 && AuthMech.REQUIRE == authMech || bl2 && AuthMech.ALLOW == authMech || bl2 && AuthMech.PREFER == authMech) && null != this.m_settings.m_authMech && this.m_settings.m_authMech != authMech) {
            this.throwConflictingPropertyException(new String[]{PGJDBCPropertyKey.AUTH_MECH_KEY.getKey(), PGJDBCPropertyKey.SSL.getKey()});
        }
        if (bl3) {
            this.m_settings.m_authMech = authMech;
            if (AuthMech.DISABLE == authMech) {
                bl4 = true;
            }
        }
        Variant variant3 = this.getOptionalSetting(PGJDBCPropertyKey.SSL_FACTORY.getKey(), connSettingRequestMap);
        boolean bl5 = false;
        if (null != variant3 && this.isNonValidationFactory(variant3.getString())) {
            if (bl3 && this.m_settings.m_authMech != AuthMech.REQUIRE) {
                this.throwConflictingPropertyException(new String[]{PGJDBCPropertyKey.AUTH_MECH_KEY.getKey(), PGJDBCPropertyKey.SSL_FACTORY.getKey()});
            }
            bl5 = true;
            this.m_settings.m_authMech = AuthMech.REQUIRE;
        }
        Variant variant4 = this.getOptionalSetting(PGJDBCPropertyKey.SSL_MODE.getKey(), connSettingRequestMap);
        boolean bl6 = false;
        if (null != variant4) {
            bl6 = true;
        }
        if (bl6) {
            if (bl3 && AuthMech.REQUIRE != authMech) {
                this.throwConflictingPropertyException(new String[]{PGJDBCPropertyKey.SSL_MODE.getKey(), PGJDBCPropertyKey.AUTH_MECH_KEY.getKey()});
            }
            if (bl2) {
                this.throwConflictingPropertyException(new String[]{PGJDBCPropertyKey.SSL_MODE.getKey(), PGJDBCPropertyKey.SSL.getKey()});
            }
            if (bl5) {
                this.throwConflictingPropertyException(new String[]{PGJDBCPropertyKey.SSL_MODE.getKey(), PGJDBCPropertyKey.SSL_FACTORY.getKey()});
            }
            if (variant4.getString().equals(PGJDBCPropertyKey.SSL_MODE_VERIFY_FULL.getKey())) {
                this.m_settings.m_authMech = AuthMech.VERIFY_FULL;
            } else if (variant4.getString().equals(PGJDBCPropertyKey.SSL_MODE_VERIFY_CA.getKey())) {
                this.m_settings.m_authMech = AuthMech.VERIFY_CA;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(PGJDBCPropertyKey.SSL_MODE_VERIFY_FULL.getKey());
                stringBuilder.append(", ");
                stringBuilder.append(PGJDBCPropertyKey.SSL_MODE_VERIFY_CA.getKey());
                ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{PGJDBCPropertyKey.SSL_MODE.getKey(), stringBuilder.toString()});
                LogUtilities.logError(errorException, this.m_log);
                throw errorException;
            }
        }
        if (!(bl || bl2 || bl5 || bl6 || bl4)) {
            this.m_settings.m_authMech = AuthMech.VERIFY_CA;
        }
    }

    private void throwConflictingPropertyException(String[] stringArray) throws ErrorException {
        ErrorException errorException = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_PROPERTY_CONFLICT_ERR.name(), stringArray);
        LogUtilities.logError(errorException, this.m_log);
        throw errorException;
    }

    private boolean isNonValidationFactory(String string) {
        boolean bl = false;
        if (string.equals(PGCoreUtils.NON_VALIDATING_SSL_FACTORY) || string.equals(NonValidatingFactory.class.getName())) {
            bl = true;
        }
        return bl;
    }

    private Warning buildWarningForIncorrectIntPropertyValue(String string) {
        String[] stringArray = new String[2];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Numbers between 0 and 2147483647");
        stringBuilder.append(". The value is either negative, too large or not a number. ");
        stringBuilder.append("Falling back to the default value");
        stringArray[0] = string;
        stringArray[1] = stringBuilder.toString();
        return new Warning(WarningCode.GENERAL_WARNING, 101, PGJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), stringArray);
    }

    public static Variant getOptionalConnSetting(String string, ConnSettingRequestMap connSettingRequestMap) {
        return connSettingRequestMap.getProperty(string);
    }

    public static Variant getRequiredConnSetting(String string, ConnSettingRequestMap connSettingRequestMap) throws BadAuthException {
        Variant variant = connSettingRequestMap.getProperty(string);
        if (null == variant) {
            throw new BadAuthException(2, DSIMessageKey.REQ_SETTING_NOT_FOUND.name(), string);
        }
        return variant;
    }
}

